
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Stormwater Calculator Australia</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Stormwater Calculator Australia</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Stormwater Calculation Formula:
                </p>
<div class="formula-container">
    \[ V = A \times R \times C \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="area" class="label-box">Area (A):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="area" name="area" step="0.0001" min="0" value="<?php echo isset($_POST['area']) ? htmlspecialchars($_POST['area']) : ''; ?>" required>
                                <span class="calc-input">m²</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="rainfall" class="label-box">Rainfall (R):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="rainfall" name="rainfall" step="0.0001" min="0" value="<?php echo isset($_POST['rainfall']) ? htmlspecialchars($_POST['rainfall']) : ''; ?>" required>
                                <span class="calc-input">mm</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="coefficient" class="label-box">Coefficient (C):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="coefficient" name="coefficient" step="0.0001" min="0" max="1" value="<?php echo isset($_POST['coefficient']) ? htmlspecialchars($_POST['coefficient']) : ''; ?>" required>
                                <span class="calc-input">dimensionless</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['area']) && 
                        isset($_POST['rainfall']) &&
                        isset($_POST['coefficient'])) {
                        
                        // Get input values
                        $area = floatval($_POST['area']);
                        $rainfall = floatval($_POST['rainfall']);
                        $coefficient = floatval($_POST['coefficient']);

                        if ($area > 0 && $rainfall > 0 && $coefficient > 0) {
                            // Calculate stormwater volume
                            $V = $area * ($rainfall / 1000) * $coefficient; // Convert mm to meters
                            $V = round($V, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Stormwater Volume (V):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($V) ? htmlspecialchars($V) . " m³" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Stormwater Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Stormwater Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Stormwater Calculation?</h3>
                <p>
The stormwater calculation estimates the volume of stormwater runoff from a given area using the rational method formula. This is particularly important in Australian urban planning and drainage design to manage water flow and prevent flooding.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the stormwater formula:
                </p>
                <div class="formula-2-container">
                    \[ V = A \times R \times C \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( V \) — Stormwater volume (m³)</li>
                        <li>\( A \) — Catchment area (m²)</li>
                        <li>\( R \) — Rainfall depth (mm)</li>
                        <li>\( C \) — Runoff coefficient (dimensionless)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula calculates the volume of water that will run off a surface during a rainfall event, accounting for the area size, rainfall intensity, and surface characteristics through the coefficient.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Stormwater Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate stormwater calculation is crucial for designing effective drainage systems, preventing urban flooding, managing water resources, and meeting Australian environmental regulations and building codes.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter area in square meters, rainfall in millimeters, and appropriate runoff coefficient (typically 0.05-0.95 depending on surface type). All values must be positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What are typical runoff coefficients for different surfaces?</strong><br>
                    A: Roofs: 0.75-0.95, Pavement: 0.70-0.95, Lawns: 0.05-0.35, Forest: 0.05-0.25. Values vary based on slope and soil conditions.
                </p>
                <p>
                    <strong>Q2: How does this calculation apply to Australian conditions?</strong><br>
                    A: This method is widely used in Australian stormwater management and aligns with Australian Rainfall and Runoff guidelines for urban drainage design.
                </p>
                <p>
                    <strong>Q3: What time period does the rainfall represent?</strong><br>
                    A: The rainfall value typically represents the design storm intensity for a specific duration and average recurrence interval relevant to the location.
                </p>
                <p>
                    <strong>Q4: Are there limitations to this calculation method?</strong><br>
                    A: The rational method is best suited for small catchments (typically < 200 hectares) and may not account for complex hydrological processes in larger watersheds.
                </p>
                <p>
                    <strong>Q5: How is the result used in practical applications?</strong><br>
                    A: The calculated volume helps determine pipe sizes, storage requirements, and drainage infrastructure needed to handle stormwater runoff in Australian urban developments.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Stormwater Calculator Australia© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
