
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Stormwater Calculator Epa</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Stormwater Calculator Epa</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    EPA Stormwater Equation:
                </p>
<div class="formula-container">
    \[ V = \frac{Area \times Rainfall \times Coefficient}{12} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="area" class="label-box">Area:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="area" name="area" step="0.0001" min="0" value="<?php echo isset($_POST['area']) ? htmlspecialchars($_POST['area']) : ''; ?>" required>
                                <span class="calc-input">sq ft</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="rainfall" class="label-box">Rainfall:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="rainfall" name="rainfall" step="0.0001" min="0" value="<?php echo isset($_POST['rainfall']) ? htmlspecialchars($_POST['rainfall']) : ''; ?>" required>
                                <span class="calc-input">in</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="coefficient" class="label-box">Coefficient:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="coefficient" name="coefficient" step="0.0001" min="0" max="1" value="<?php echo isset($_POST['coefficient']) ? htmlspecialchars($_POST['coefficient']) : ''; ?>" required>
                                <span class="calc-input">dimensionless</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['area']) && 
                        isset($_POST['rainfall']) &&
                        isset($_POST['coefficient'])) {
                        
                        // Get input values
                        $area = floatval($_POST['area']);
                        $rainfall = floatval($_POST['rainfall']);
                        $coefficient = floatval($_POST['coefficient']);

                        if ($area > 0 && $rainfall > 0 && $coefficient > 0) {
                            // Calculate stormwater volume using EPA equation
                            $volume = ($area * $rainfall * $coefficient) / 12;
                            $volume = round($volume, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Stormwater Volume (V):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($volume) ? htmlspecialchars($volume) . " ft³" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the EPA Stormwater Equation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Stormwater Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the EPA Stormwater Equation?</h3>
                <p>
The EPA (Environmental Protection Agency) stormwater equation calculates stormwater runoff volume from a given area. It is used to estimate the amount of water that needs to be managed during rainfall events for proper drainage system design and environmental protection.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the EPA stormwater equation:
                </p>
                <div class="formula-2-container">
                    \[ V = \frac{Area \times Rainfall \times Coefficient}{12} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( V \) — Stormwater volume (ft³)</li>
                        <li>\( Area \) — Surface area (sq ft)</li>
                        <li>\( Rainfall \) — Rainfall depth (in)</li>
                        <li>\( Coefficient \) — Runoff coefficient (dimensionless)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation accounts for the relationship between surface area, rainfall intensity, and surface characteristics to estimate runoff volume.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Stormwater Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate stormwater volume estimation is crucial for designing effective drainage systems, preventing flooding, managing water resources, and meeting environmental regulations.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter area in square feet, rainfall in inches, and appropriate runoff coefficient. All values must be valid positive numbers (area > 0, rainfall > 0, coefficient between 0-1).
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is the runoff coefficient?</strong><br>
                    A: The runoff coefficient represents the fraction of rainfall that becomes surface runoff, ranging from 0 (all water infiltrates) to 1 (all water runs off).
                </p>
                <p>
                    <strong>Q2: How do I determine the appropriate coefficient?</strong><br>
                    A: Coefficients vary by surface type: pavement (0.8-0.95), grass (0.05-0.35), forest (0.01-0.20). Consult EPA guidelines for specific values.
                </p>
                <p>
                    <strong>Q3: Why divide by 12 in the equation?</strong><br>
                    A: The division by 12 converts inches to feet, ensuring consistent units throughout the calculation (ft³ = sq ft × in × coefficient ÷ 12).
                </p>
                <p>
                    <strong>Q4: When should this calculation be used?</strong><br>
                    A: This calculation is used for stormwater management planning, drainage system design, environmental impact assessments, and regulatory compliance.
                </p>
                <p>
                    <strong>Q5: Are there limitations to this equation?</strong><br>
                    A: The equation provides an estimate and may not account for complex terrain, soil saturation, or extreme rainfall events. Professional engineering assessment may be required for critical applications.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Stormwater Calculator Epa© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>