
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Stormwater Capacity Calculation</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Stormwater Capacity Calculation</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Stormwater Capacity Formula:
                </p>
<div class="formula-container">
    \[ V = A \times R \times C \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="area" class="label-box">Area (A):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="area" name="area" step="0.0001" min="0" value="<?php echo isset($_POST['area']) ? htmlspecialchars($_POST['area']) : ''; ?>" required>
                                <span class="calc-input">m²</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="rainfall" class="label-box">Rainfall (R):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="rainfall" name="rainfall" step="0.0001" min="0" value="<?php echo isset($_POST['rainfall']) ? htmlspecialchars($_POST['rainfall']) : ''; ?>" required>
                                <span class="calc-input">m</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="runoff_coefficient" class="label-box">Runoff Coefficient (C):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="runoff_coefficient" name="runoff_coefficient" step="0.01" min="0" max="1" value="<?php echo isset($_POST['runoff_coefficient']) ? htmlspecialchars($_POST['runoff_coefficient']) : ''; ?>" required>
                                <span class="calc-input">dimensionless</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['area']) && 
                        isset($_POST['rainfall']) &&
                        isset($_POST['runoff_coefficient'])) {
                        
                        // Get input values
                        $area = floatval($_POST['area']);
                        $rainfall = floatval($_POST['rainfall']);
                        $runoff_coefficient = floatval($_POST['runoff_coefficient']);

                        if ($area > 0 && $rainfall > 0 && $runoff_coefficient > 0) {
                            // Calculate stormwater capacity
                            $v = $area * $rainfall * $runoff_coefficient;
                            $v = round($v, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Stormwater Capacity (V):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($v) ? htmlspecialchars($v) . " m³" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Stormwater Capacity?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Stormwater Capacity Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Stormwater Capacity?</h3>
                <p>
Stormwater capacity refers to the volume of water that needs to be managed during rainfall events. It's calculated based on the catchment area, rainfall intensity, and the runoff coefficient which represents the portion of rainfall that becomes surface runoff.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the stormwater capacity formula:
                </p>
                <div class="formula-2-container">
                    \[ V = A \times R \times C \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( V \) — Stormwater capacity (m³)</li>
                        <li>\( A \) — Catchment area (m²)</li>
                        <li>\( R \) — Rainfall depth (m)</li>
                        <li>\( C \) — Runoff coefficient (dimensionless)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula calculates the volume of stormwater runoff by multiplying the catchment area by the rainfall depth and the runoff coefficient.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Stormwater Capacity Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate stormwater capacity calculation is crucial for designing effective drainage systems, preventing flooding, managing water resources, and meeting regulatory requirements for stormwater management.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the catchment area in square meters, rainfall depth in meters, and the appropriate runoff coefficient. The runoff coefficient typically ranges from 0 (no runoff) to 1 (all rainfall becomes runoff), with common values around 0.3-0.9 depending on surface type.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is a runoff coefficient?</strong><br>
                    A: The runoff coefficient represents the fraction of rainfall that becomes surface runoff rather than being absorbed or evaporated. It varies based on surface type, slope, and soil conditions.
                </p>
                <p>
                    <strong>Q2: How do I determine the appropriate runoff coefficient?</strong><br>
                    A: Runoff coefficients are typically determined from engineering tables based on surface characteristics. For example: paved areas (0.8-0.95), lawns (0.05-0.35), forests (0.01-0.20).
                </p>
                <p>
                    <strong>Q3: Why is rainfall measured in meters?</strong><br>
                    A: Rainfall is typically measured in millimeters, but for volume calculations, we convert to meters (1 mm = 0.001 m) to maintain consistent units with area (m²) and volume (m³).
                </p>
                <p>
                    <strong>Q4: Can this calculator be used for different time periods?</strong><br>
                    A: Yes, but the rainfall value should correspond to the design storm duration you're analyzing (e.g., 24-hour rainfall, 1-hour rainfall).
                </p>
                <p>
                    <strong>Q5: What are typical applications of stormwater capacity calculations?</strong><br>
                    A: These calculations are used in designing drainage systems, sizing retention ponds, planning flood control measures, and meeting regulatory requirements for stormwater management.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Stormwater Capacity Calculation© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
