
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Stormwater Pit Size Calculator Australia</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Stormwater Pit Size Calculator Australia</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Stormwater Pit Size Equation:
                </p>
<div class="formula-container">
    \[ Size = Catchment Area \times Rainfall Intensity \times Duration \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="catchment_area" class="label-box">Catchment Area:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="catchment_area" name="catchment_area" step="0.0001" min="0" value="<?php echo isset($_POST['catchment_area']) ? htmlspecialchars($_POST['catchment_area']) : ''; ?>" required>
                                <span class="calc-input">m²</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="rainfall_intensity" class="label-box">Rainfall Intensity:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="rainfall_intensity" name="rainfall_intensity" step="0.0001" min="0" value="<?php echo isset($_POST['rainfall_intensity']) ? htmlspecialchars($_POST['rainfall_intensity']) : ''; ?>" required>
                                <span class="calc-input">mm/h</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="duration" class="label-box">Duration:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="duration" name="duration" step="0.0001" min="0" value="<?php echo isset($_POST['duration']) ? htmlspecialchars($_POST['duration']) : ''; ?>" required>
                                <span class="calc-input">h</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['catchment_area']) && 
                        isset($_POST['rainfall_intensity']) &&
                        isset($_POST['duration'])) {
                        
                        // Get input values
                        $catchment_area = floatval($_POST['catchment_area']);
                        $rainfall_intensity = floatval($_POST['rainfall_intensity']);
                        $duration = floatval($_POST['duration']);

                        if ($catchment_area > 0 && $rainfall_intensity > 0 && $duration > 0) {
                            // Calculate stormwater pit size
                            $size = $catchment_area * ($rainfall_intensity / 1000) * $duration;
                            $size = round($size, 3);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Stormwater Pit Size:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($size) ? htmlspecialchars($size) . " m³" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Stormwater Pit Size Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Proper Sizing</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Stormwater Pit Size Calculation?</h3>
                <p>
The stormwater pit size calculation determines the required volume capacity for stormwater pits in Australian conditions. It considers catchment area, rainfall intensity, and duration to ensure adequate water storage and management during storm events.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the stormwater pit size equation:
                </p>
                <div class="formula-2-container">
                    \[ Size = Catchment Area \times Rainfall Intensity \times Duration \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Catchment Area \) — Area draining into the pit (m²)</li>
                        <li>\( Rainfall Intensity \) — Rainfall intensity (mm/h)</li>
                        <li>\( Duration \) — Storm duration (h)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates the total volume of water that needs to be managed during a storm event, accounting for the catchment area, rainfall intensity, and storm duration.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Proper Sizing</h3>
                <p>
                    <strong>Details:</strong> Proper stormwater pit sizing is crucial for effective stormwater management, preventing flooding, erosion, and infrastructure damage. Undersized pits can lead to overflow and property damage, while oversized pits may be unnecessarily costly.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter catchment area in square meters, rainfall intensity in millimeters per hour, and duration in hours. All values must be positive numbers for accurate calculation.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is catchment area?</strong><br>
                    A: Catchment area refers to the total surface area that drains into the stormwater pit, including roofs, pavements, and other impervious surfaces.
                </p>
                <p>
                    <strong>Q2: How do I determine rainfall intensity?</strong><br>
                    A: Rainfall intensity data can be obtained from local meteorological data or Australian rainfall intensity charts specific to your region.
                </p>
                <p>
                    <strong>Q3: What duration should I use for calculation?</strong><br>
                    A: Duration depends on local storm characteristics. Typically, 1-2 hours is used for standard residential calculations, but consult local guidelines.
                </p>
                <p>
                    <strong>Q4: Are there Australian standards for stormwater pit sizing?</strong><br>
                    A: Yes, various Australian standards and local council requirements govern stormwater management. Always consult local regulations.
                </p>
                <p>
                    <strong>Q5: Does this calculation account for infiltration?</strong><br>
                    A: This basic calculation assumes no infiltration. For more accurate results, soil type and infiltration rates should be considered.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Stormwater Pit Size Calculator Australia© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>