
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Stormwater Runoff Calculator Australia</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Stormwater Runoff Calculator Australia</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Stormwater Runoff Equation:
                </p>
<div class="formula-container">
    \[ Runoff = Area \times Rainfall \times Coefficient \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="area_aus" class="label-box">Area (Area_aus):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="area_aus" name="area_aus" step="0.0001" min="0" value="<?php echo isset($_POST['area_aus']) ? htmlspecialchars($_POST['area_aus']) : ''; ?>" required>
                                <span class="calc-input">m²</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="rainfall_aus" class="label-box">Rainfall (Rainfall_aus):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="rainfall_aus" name="rainfall_aus" step="0.0001" min="0" value="<?php echo isset($_POST['rainfall_aus']) ? htmlspecialchars($_POST['rainfall_aus']) : ''; ?>" required>
                                <span class="calc-input">mm</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="coefficient_aus" class="label-box">Coefficient (Coefficient_aus):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="coefficient_aus" name="coefficient_aus" step="0.0001" min="0" max="1" value="<?php echo isset($_POST['coefficient_aus']) ? htmlspecialchars($_POST['coefficient_aus']) : ''; ?>" required>
                                <span class="calc-input">dimensionless</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['area_aus']) && 
                        isset($_POST['rainfall_aus']) &&
                        isset($_POST['coefficient_aus'])) {
                        
                        // Get input values
                        $area_aus = floatval($_POST['area_aus']);
                        $rainfall_aus = floatval($_POST['rainfall_aus']);
                        $coefficient_aus = floatval($_POST['coefficient_aus']);

                        if ($area_aus > 0 && $rainfall_aus > 0 && $coefficient_aus > 0) {
                            // Calculate stormwater runoff
                            $runoff = $area_aus * $rainfall_aus * $coefficient_aus;
                            $runoff = round($runoff, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Stormwater Runoff (Runoff):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($runoff) ? htmlspecialchars($runoff) . " m³" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Stormwater Runoff Equation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Stormwater Runoff Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Stormwater Runoff Equation?</h3>
                <p>
The Stormwater Runoff Equation calculates the volume of stormwater runoff from a given area based on rainfall intensity and surface characteristics. It's commonly used in Australian water management and urban planning to estimate runoff volumes for drainage design and flood management.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the Stormwater Runoff equation:
                </p>
                <div class="formula-2-container">
                    \[ Runoff = Area \times Rainfall \times Coefficient \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Area \) — Catchment area in square meters (m²)</li>
                        <li>\( Rainfall \) — Rainfall depth in millimeters (mm)</li>
                        <li>\( Coefficient \) — Runoff coefficient (dimensionless, 0-1)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation multiplies the catchment area by the rainfall depth and a runoff coefficient that represents the proportion of rainfall that becomes surface runoff.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Stormwater Runoff Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate runoff calculation is crucial for designing effective drainage systems, managing flood risks, planning urban infrastructure, and implementing sustainable water management practices in Australian conditions.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter area in square meters, rainfall in millimeters, and appropriate runoff coefficient (typically 0.05-0.95 depending on surface type). All values must be positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What are typical runoff coefficient values for Australian conditions?</strong><br>
                    A: Typical values range from 0.05-0.10 for natural areas, 0.30-0.45 for lawns, 0.70-0.95 for paved surfaces, and 0.85-0.95 for roofs.
                </p>
                <p>
                    <strong>Q2: How does this equation account for Australian rainfall patterns?</strong><br>
                    A: The equation uses actual rainfall measurements which can incorporate Australia's varied rainfall patterns, from tropical north to arid interior.
                </p>
                <p>
                    <strong>Q3: When should this calculation be used?</strong><br>
                    A: For drainage design, flood risk assessment, stormwater management planning, and compliance with Australian water regulations and guidelines.
                </p>
                <p>
                    <strong>Q4: Are there limitations to this equation?</strong><br>
                    A: The simple equation doesn't account for rainfall intensity, duration, soil moisture, or complex catchment characteristics. More sophisticated models may be needed for large or complex catchments.
                </p>
                <p>
                    <strong>Q5: How does this relate to Australian standards?</strong><br>
                    A: This basic equation forms the foundation for more complex methods in Australian Rainfall and Runoff guidelines and various state-based stormwater management requirements.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Stormwater Runoff Calculator Australia© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>