
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Stormwater Volume Calculation</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Stormwater Volume Calculation</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Stormwater Runoff Volume Formula:
                </p>
<div class="formula-container">
    \[ V (m³) = Rainfall (mm) \times Area (m²) / 1000 \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="rainfall" class="label-box">Rainfall:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="rainfall" name="rainfall" step="0.01" min="0" value="<?php echo isset($_POST['rainfall']) ? htmlspecialchars($_POST['rainfall']) : ''; ?>" required>
                                <span class="calc-input">millimeters</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="area" class="label-box">Area:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="area" name="area" step="0.01" min="0" value="<?php echo isset($_POST['area']) ? htmlspecialchars($_POST['area']) : ''; ?>" required>
                                <span class="calc-input">square meters</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['rainfall']) && 
                        isset($_POST['area'])) {
                        
                        // Get input values
                        $rainfall = floatval($_POST['rainfall']);
                        $area = floatval($_POST['area']);

                        if ($rainfall > 0 && $area > 0) {
                            // Calculate stormwater volume
                            $volume = ($rainfall * $area) / 1000;
                            $volume = round($volume, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Stormwater Volume:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($volume) ? htmlspecialchars($volume) . " cubic meters" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Stormwater Runoff Volume Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Stormwater Volume Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Stormwater Runoff Volume Calculation?</h3>
                <p>
Stormwater runoff volume calculation estimates the amount of water that will run off a surface during a rainfall event. This is essential for designing drainage systems, managing flood risks, and planning water conservation measures.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the stormwater runoff volume formula:
                </p>
                <div class="formula-2-container">
                    \[ V (m³) = Rainfall (mm) \times Area (m²) / 1000 \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( V \) — Stormwater volume (cubic meters)</li>
                        <li>\( Rainfall \) — Precipitation depth (millimeters)</li>
                        <li>\( Area \) — Catchment area (square meters)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula converts rainfall depth to volume by multiplying by the catchment area and dividing by 1000 to convert from liters to cubic meters.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Stormwater Volume Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate stormwater volume calculation is crucial for designing effective drainage systems, preventing flooding, managing water resources, and meeting regulatory requirements for stormwater management.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter rainfall in millimeters and area in square meters. Both values must be positive numbers. The calculator will provide the stormwater volume in cubic meters.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Why divide by 1000 in the formula?</strong><br>
                    A: The division by 1000 converts the result from liters to cubic meters (1 cubic meter = 1000 liters).
                </p>
                <p>
                    <strong>Q2: What is a typical rainfall value to use?</strong><br>
                    A: Use local rainfall data for your specific design storm. Common values range from 10-100 mm depending on climate and storm intensity.
                </p>
                <p>
                    <strong>Q3: Does this account for infiltration or evaporation?</strong><br>
                    A: No, this is a simple volumetric calculation that assumes all rainfall becomes runoff. For more accurate results, consider infiltration rates and evaporation losses.
                </p>
                <p>
                    <strong>Q4: Can I use different units?</strong><br>
                    A: The calculator is designed for mm and m². Convert other units accordingly (1 inch = 25.4 mm, 1 square foot = 0.0929 m²).
                </p>
                <p>
                    <strong>Q5: How accurate is this calculation?</strong><br>
                    A: This provides a theoretical maximum volume. Actual runoff may be less due to infiltration, surface retention, and other factors.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Stormwater Volume Calculation© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>