
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Strike Water Calculator Brewing</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Strike Water Calculator Brewing</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Strike Water Formula:
                </p>
<div class="formula-container">
    \[ Volume (l) = Grain (kg) \times Ratio (l/kg) \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="grain" class="label-box">Grain:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="grain" name="grain" step="0.01" min="0" value="<?php echo isset($_POST['grain']) ? htmlspecialchars($_POST['grain']) : ''; ?>" required>
                                <span class="calc-input">kg</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="ratio" class="label-box">Ratio:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="ratio" name="ratio" step="0.01" min="0" value="<?php echo isset($_POST['ratio']) ? htmlspecialchars($_POST['ratio']) : ''; ?>" required>
                                <span class="calc-input">l/kg</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['grain']) && 
                        isset($_POST['ratio'])) {
                        
                        // Get input values
                        $grain = floatval($_POST['grain']);
                        $ratio = floatval($_POST['ratio']);

                        if ($grain > 0 && $ratio > 0) {
                            // Calculate strike water volume
                            $volume = $grain * $ratio;
                            $volume = round($volume, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Volume:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($volume) ? htmlspecialchars($volume) . " l" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Strike Water Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Strike Water Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Strike Water Calculation?</h3>
                <p>
Strike water calculation determines the amount of water needed for mashing in brewing. It's based on the grain bill weight and the desired water-to-grain ratio, which affects mash temperature and efficiency.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the strike water formula:
                </p>
                <div class="formula-2-container">
                    \[ Volume (l) = Grain (kg) \times Ratio (l/kg) \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Grain \) — Total grain weight in kilograms</li>
                        <li>\( Ratio \) — Water-to-grain ratio in liters per kilogram</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula calculates the volume of water needed to achieve the desired consistency and temperature for optimal starch conversion during mashing.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Strike Water Calculation</h3>
                <p>
                    <strong>Details:</strong> Proper strike water calculation ensures correct mash thickness, which affects enzyme activity, temperature stability, and ultimately the efficiency of sugar extraction from grains.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter total grain weight in kilograms and desired water-to-grain ratio. Typical ratios range from 2.5-3.5 l/kg depending on the beer style and brewing system.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is the ideal water-to-grain ratio?</strong><br>
                    A: Most brewers use 2.6-3.0 l/kg, with thinner mashes (higher ratios) typically producing higher efficiency but potentially thinner-bodied beers.
                </p>
                <p>
                    <strong>Q2: Does this account for water absorption?</strong><br>
                    A: This calculates total strike water volume. Grain absorption (typically 0.8-1.2 l/kg) should be considered separately for sparging calculations.
                </p>
                <p>
                    <strong>Q3: How does ratio affect mash temperature?</strong><br>
                    A: Thicker mashes (lower ratios) are more temperature-stable, while thinner mashes (higher ratios) may cool faster but allow better enzyme movement.
                </p>
                <p>
                    <strong>Q4: Should I adjust for equipment loss?</strong><br>
                    A: Yes, many systems have dead space or evaporation losses that should be added to the calculated strike water volume.
                </p>
                <p>
                    <strong>Q5: Can this be used for partial mash brewing?</strong><br>
                    A: Yes, the formula works for any amount of grain, though very small batches may need ratio adjustments for temperature stability.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Strike Water Calculator Brewing© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
