
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Thames Water Meter Installation Cost Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Thames Water Meter Installation Cost Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Thames Water Meter Installation Cost Formula:
                </p>
<div class="formula-container">
    \[ Cost = Base + (Distance \times Rate) \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="base" class="label-box">Base Cost:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="base" name="base" step="0.01" min="0" value="<?php echo isset($_POST['base']) ? htmlspecialchars($_POST['base']) : ''; ?>" required>
                                <span class="calc-input">£</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="distance" class="label-box">Distance:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="distance" name="distance" step="0.01" min="0" value="<?php echo isset($_POST['distance']) ? htmlspecialchars($_POST['distance']) : ''; ?>" required>
                                <span class="calc-input">m</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="rate" class="label-box">Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="rate" name="rate" step="0.01" min="0" value="<?php echo isset($_POST['rate']) ? htmlspecialchars($_POST['rate']) : ''; ?>" required>
                                <span class="calc-input">£/m</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['base']) && 
                        isset($_POST['distance']) &&
                        isset($_POST['rate'])) {
                        
                        // Get input values
                        $base = floatval($_POST['base']);
                        $distance = floatval($_POST['distance']);
                        $rate = floatval($_POST['rate']);

                        if ($base >= 0 && $distance >= 0 && $rate >= 0) {
                            // Calculate total cost
                            $cost = $base + ($distance * $rate);
                            $cost = round($cost, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Total Installation Cost:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($cost) ? "£" . htmlspecialchars($cost) : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Thames Water Meter Installation Cost?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Cost Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Thames Water Meter Installation Cost?</h3>
                <p>
The Thames Water Meter Installation Cost calculation estimates the total expense for installing a water meter, considering both a base installation fee and additional costs based on the distance of installation.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the formula:
                </p>
                <div class="formula-2-container">
                    \[ Cost = Base + (Distance \times Rate) \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Base \) — Base installation cost (£)</li>
                        <li>\( Distance \) — Installation distance (m)</li>
                        <li>\( Rate \) — Cost per meter (£/m)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates the total cost by adding the base installation fee to the product of distance and rate per meter.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Cost Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate cost estimation is crucial for budgeting and planning Thames Water meter installations, helping customers understand the total expenses involved.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the base cost in £, distance in meters, and rate in £/m. All values must be valid (non-negative numbers).
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is included in the base cost?</strong><br>
                    A: The base cost typically includes standard installation materials, labor, and basic setup fees.
                </p>
                <p>
                    <strong>Q2: How is distance measured?</strong><br>
                    A: Distance is measured from the main water connection point to the installation location in meters.
                </p>
                <p>
                    <strong>Q3: Are there any additional fees?</strong><br>
                    A: Additional fees may apply for complex installations, permits, or special requirements not covered in the standard rate.
                </p>
                <p>
                    <strong>Q4: Can I get an exact quote from this calculator?</strong><br>
                    A: This calculator provides an estimate. For an exact quote, contact Thames Water directly with your specific installation details.
                </p>
                <p>
                    <strong>Q5: Is the rate fixed or variable?</strong><br>
                    A: The rate may vary based on installation complexity, location, and current Thames Water pricing policies.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Thames Water Meter Installation Cost Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>