
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Viscosity Of Water Calculator Cp</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Viscosity Of Water Calculator Cp</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Viscosity Equation:
                </p>
<div class="formula-container">
    \[ \mu = A \times 10^{(B / (T - C))} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="temperature" class="label-box">Temperature (T):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="temperature" name="temperature" step="0.01" min="0" value="<?php echo isset($_POST['temperature']) ? htmlspecialchars($_POST['temperature']) : ''; ?>" required>
                                <span class="calc-input">°C</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="constant_a" class="label-box">Constant A:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="constant_a" name="constant_a" step="0.000001" min="0" value="<?php echo isset($_POST['constant_a']) ? htmlspecialchars($_POST['constant_a']) : '0.00179'; ?>" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="constant_b" class="label-box">Constant B:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="constant_b" name="constant_b" step="0.000001" min="0" value="<?php echo isset($_POST['constant_b']) ? htmlspecialchars($_POST['constant_b']) : '1230'; ?>" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="constant_c" class="label-box">Constant C:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="constant_c" name="constant_c" step="0.000001" min="0" value="<?php echo isset($_POST['constant_c']) ? htmlspecialchars($_POST['constant_c']) : '168'; ?>" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['temperature']) && 
                        isset($_POST['constant_a']) &&
                        isset($_POST['constant_b']) &&
                        isset($_POST['constant_c'])) {
                        
                        // Get input values
                        $temperature = floatval($_POST['temperature']);
                        $constant_a = floatval($_POST['constant_a']);
                        $constant_b = floatval($_POST['constant_b']);
                        $constant_c = floatval($_POST['constant_c']);

                        if ($temperature > 0 && $constant_a > 0 && $constant_b > 0 && $constant_c > 0) {
                            // Calculate viscosity using the formula
                            $viscosity = $constant_a * pow(10, ($constant_b / ($temperature - $constant_c)));
                            $viscosity = round($viscosity, 6);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Viscosity (μ):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($viscosity) ? htmlspecialchars($viscosity) . " cP" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Water Viscosity?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Viscosity Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Water Viscosity?</h3>
                <p>
Water viscosity refers to the measure of a fluid's resistance to flow. For water, viscosity decreases as temperature increases, making it an important property in various scientific and engineering applications.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the viscosity equation:
                </p>
                <div class="formula-2-container">
                    \[ \mu = A \times 10^{(B / (T - C))} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( \mu \) — Viscosity in centipoise (cP)</li>
                        <li>\( A \) — Empirical constant (typically 0.00179)</li>
                        <li>\( B \) — Empirical constant (typically 1230)</li>
                        <li>\( T \) — Temperature in Celsius (°C)</li>
                        <li>\( C \) — Empirical constant (typically 168)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> This empirical formula describes how water viscosity changes with temperature, following an exponential relationship.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Viscosity Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate viscosity calculation is crucial for fluid dynamics, chemical engineering, pharmaceutical manufacturing, and many industrial processes where fluid flow properties are critical.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter temperature in Celsius and the empirical constants A, B, and C. Standard values are pre-filled but can be adjusted for different fluid properties.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What are typical values for constants A, B, and C?</strong><br>
                    A: For water, typical values are A = 0.00179, B = 1230, and C = 168, but these may vary slightly depending on the specific empirical model.
                </p>
                <p>
                    <strong>Q2: How does temperature affect water viscosity?</strong><br>
                    A: Water viscosity decreases exponentially as temperature increases. At 20°C, viscosity is about 1.002 cP, while at 100°C it's approximately 0.282 cP.
                </p>
                <p>
                    <strong>Q3: What is the unit of measurement for viscosity?</strong><br>
                    A: Viscosity is typically measured in centipoise (cP) or Pascal-seconds (Pa·s), where 1 cP = 0.001 Pa·s.
                </p>
                <p>
                    <strong>Q4: Why is water viscosity important?</strong><br>
                    A: Understanding water viscosity is essential for designing fluid systems, predicting flow behavior, and in processes like mixing, pumping, and filtration.
                </p>
                <p>
                    <strong>Q5: Can this calculator be used for other fluids?</strong><br>
                    A: While the formula structure is similar for many Newtonian fluids, different constants would be needed for fluids other than water.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Viscosity Of Water Calculator Cp© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
