
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Balance Calculation</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Balance Calculation</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Balance Equation:
                </p>
<div class="formula-container">
    \[ Balance = Precipitation - Evapotranspiration - Runoff \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="precipitation" class="label-box">Precipitation:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="precipitation" name="precipitation" step="0.0001" min="0" value="<?php echo isset($_POST['precipitation']) ? htmlspecialchars($_POST['precipitation']) : ''; ?>" required>
                                <span class="calc-input">mm</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="evapotranspiration" class="label-box">Evapotranspiration:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="evapotranspiration" name="evapotranspiration" step="0.0001" min="0" value="<?php echo isset($_POST['evapotranspiration']) ? htmlspecialchars($_POST['evapotranspiration']) : ''; ?>" required>
                                <span class="calc-input">mm</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="runoff_bal" class="label-box">Runoff:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="runoff_bal" name="runoff_bal" step="0.0001" min="0" value="<?php echo isset($_POST['runoff_bal']) ? htmlspecialchars($_POST['runoff_bal']) : ''; ?>" required>
                                <span class="calc-input">mm</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['precipitation']) && 
                        isset($_POST['evapotranspiration']) &&
                        isset($_POST['runoff_bal'])) {
                        
                        // Get input values
                        $precipitation = floatval($_POST['precipitation']);
                        $evapotranspiration = floatval($_POST['evapotranspiration']);
                        $runoff_bal = floatval($_POST['runoff_bal']);

                        if ($precipitation >= 0 && $evapotranspiration >= 0 && $runoff_bal >= 0) {
                            // Calculate water balance
                            $balance = $precipitation - $evapotranspiration - $runoff_bal;
                            $balance = round($balance, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Balance:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($balance) ? htmlspecialchars($balance) . " mm" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Water Balance Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Balance Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Water Balance Calculation?</h3>
                <p>
The Water Balance Calculation estimates the net water availability by accounting for precipitation, evapotranspiration, and runoff. It provides a fundamental assessment of water resources in a given area or system.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water balance equation:
                </p>
                <div class="formula-2-container">
                    \[ Balance = Precipitation - Evapotranspiration - Runoff \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Precipitation \) — Total precipitation input (mm)</li>
                        <li>\( Evapotranspiration \) — Combined evaporation and transpiration loss (mm)</li>
                        <li>\( Runoff \) — Surface and subsurface runoff (mm)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation accounts for the fundamental water cycle components to determine the net water balance in a system.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Balance Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water balance calculation is crucial for water resource management, agricultural planning, hydrological studies, and environmental monitoring.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter precipitation, evapotranspiration, and runoff values in mm. All values must be valid (non-negative numbers).
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What does a positive water balance indicate?</strong><br>
                    A: A positive balance indicates water surplus, meaning more water is entering the system than leaving it.
                </p>
                <p>
                    <strong>Q2: What does a negative water balance indicate?</strong><br>
                    A: A negative balance indicates water deficit, meaning more water is leaving the system than entering it.
                </p>
                <p>
                    <strong>Q3: What time period should these measurements cover?</strong><br>
                    A: The calculations are typically done for specific time periods (daily, monthly, or annually) depending on the application.
                </p>
                <p>
                    <strong>Q4: Are there limitations to this calculation?</strong><br>
                    A: The calculation assumes accurate measurement of all components and doesn't account for water storage changes in the system.
                </p>
                <p>
                    <strong>Q5: How is this calculation used in practice?</strong><br>
                    A: It's used in agriculture for irrigation planning, in hydrology for watershed management, and in climate studies for water resource assessment.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Balance Calculation© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>