
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Calculator Beer</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Calculator Beer</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Sparge Water Formula:
                </p>
<div class="formula-container">
    \[ Sparge Water = Total Water - Strike Water \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="total_water" class="label-box">Total Water:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="total_water" name="total_water" step="0.01" min="0" value="<?php echo isset($_POST['total_water']) ? htmlspecialchars($_POST['total_water']) : ''; ?>" required>
                                <span class="calc-input">L</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="strike_water" class="label-box">Strike Water:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="strike_water" name="strike_water" step="0.01" min="0" value="<?php echo isset($_POST['strike_water']) ? htmlspecialchars($_POST['strike_water']) : ''; ?>" required>
                                <span class="calc-input">L</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['total_water']) && 
                        isset($_POST['strike_water'])) {
                        
                        // Get input values
                        $total_water = floatval($_POST['total_water']);
                        $strike_water = floatval($_POST['strike_water']);

                        if ($total_water > 0 && $strike_water > 0) {
                            // Calculate sparge water
                            $sparge_water = $total_water - $strike_water;
                            $sparge_water = round($sparge_water, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Sparge Water:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($sparge_water) ? htmlspecialchars($sparge_water) . " L" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Sparge Water Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Calculation in Brewing</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Sparge Water Calculation?</h3>
                <p>
Sparge water calculation is an essential part of beer brewing process. It determines the amount of water needed to rinse the grains after mashing to extract the remaining sugars. Proper sparge water calculation ensures optimal sugar extraction and desired beer characteristics.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the simple formula:
                </p>
                <div class="formula-2-container">
                    \[ Sparge Water = Total Water - Strike Water \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Total Water \) — The total amount of water needed for the brewing process</li>
                        <li>\( Strike Water \) — The initial water used for mashing the grains</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The difference between total water and strike water gives you the amount of sparge water needed to rinse the grains after mashing.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Calculation in Brewing</h3>
                <p>
                    <strong>Details:</strong> Accurate water calculation is crucial for achieving the right beer gravity, flavor profile, and efficiency in the brewing process. Proper sparging ensures maximum sugar extraction while avoiding tannin extraction from grain husks.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter total water and strike water in liters. Both values must be positive numbers, and strike water should be less than total water for a valid calculation.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Why is sparge water calculation important?</strong><br>
                    A: Proper sparge water calculation ensures optimal sugar extraction, prevents over-sparging (which can extract tannins), and helps achieve the target pre-boil volume.
                </p>
                <p>
                    <strong>Q2: What is the typical temperature for sparge water?</strong><br>
                    A: Sparge water is typically heated to 75-78°C (167-172°F) to maintain mash bed temperature and facilitate sugar extraction without extracting tannins.
                </p>
                <p>
                    <strong>Q3: Can I sparge with too much water?</strong><br>
                    A: Yes, over-sparging can lead to extraction of tannins and silicates from grain husks, resulting in astringent off-flavors in the finished beer.
                </p>
                <p>
                    <strong>Q4: How does grain absorption affect water calculations?</strong><br>
                    A: Grain typically absorbs about 0.8-1.2 L/kg of water, which should be accounted for in your total water calculation but doesn't affect the sparge water calculation directly.
                </p>
                <p>
                    <strong>Q5: Should I adjust water pH for sparging?</strong><br>
                    A: Yes, maintaining sparge water pH below 6.0 helps prevent tannin extraction. Many brewers acidify sparge water to achieve this.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Calculator Beer© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
