
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Calculator Brewing</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Calculator Brewing</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Strike Water Formula:
                </p>
<div class="formula-container">
    \[ Strike\ Water = Grain\ Weight \times Mash\ Thickness \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="grain_weight" class="label-box">Grain Weight:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="grain_weight" name="grain_weight" step="0.01" min="0" value="<?php echo isset($_POST['grain_weight']) ? htmlspecialchars($_POST['grain_weight']) : ''; ?>" required>
                                <span class="calc-input">kg</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="mash_thickness" class="label-box">Mash Thickness:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="mash_thickness" name="mash_thickness" step="0.01" min="0" value="<?php echo isset($_POST['mash_thickness']) ? htmlspecialchars($_POST['mash_thickness']) : ''; ?>" required>
                                <span class="calc-input">L/kg</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['grain_weight']) && 
                        isset($_POST['mash_thickness'])) {
                        
                        // Get input values
                        $grain_weight = floatval($_POST['grain_weight']);
                        $mash_thickness = floatval($_POST['mash_thickness']);

                        if ($grain_weight > 0 && $mash_thickness > 0) {
                            // Calculate strike water
                            $strike_water = $grain_weight * $mash_thickness;
                            $strike_water = round($strike_water, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Strike Water:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($strike_water) ? htmlspecialchars($strike_water) . " L" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Strike Water Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Strike Water Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Strike Water Calculation?</h3>
                <p>
The strike water calculation determines the volume of water needed for mashing in brewing. It's a fundamental calculation that ensures proper grain hydration and enzyme activity during the mashing process.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the strike water formula:
                </p>
                <div class="formula-2-container">
                    \[ Strike\ Water = Grain\ Weight \times Mash\ Thickness \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Grain\ Weight \) — Weight of grains in kilograms (kg)</li>
                        <li>\( Mash\ Thickness \) — Water-to-grain ratio in liters per kilogram (L/kg)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula calculates the total water volume needed based on the amount of grain and the desired thickness of the mash.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Strike Water Calculation</h3>
                <p>
                    <strong>Details:</strong> Proper strike water calculation is crucial for achieving optimal mash consistency, enzyme efficiency, and ultimately, the quality and characteristics of the final beer.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter grain weight in kilograms and mash thickness in liters per kilogram. Typical mash thickness ranges from 2.5-3.5 L/kg depending on the beer style and brewing method.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is a typical mash thickness ratio?</strong><br>
                    A: Most brewers use a ratio between 2.5-3.5 L/kg, with 3.0 L/kg being a common standard for many beer styles.
                </p>
                <p>
                    <strong>Q2: Does mash thickness affect beer characteristics?</strong><br>
                    A: Yes, thicker mashes (lower ratios) tend to produce fuller-bodied beers, while thinner mashes (higher ratios) can create drier, more fermentable worts.
                </p>
                <p>
                    <strong>Q3: Should I account for water absorption by grains?</strong><br>
                    A: This calculation provides the strike water volume only. You'll need additional calculations for sparge water accounting for grain absorption.
                </p>
                <p>
                    <strong>Q4: How does temperature affect strike water volume?</strong><br>
                    A: Water expands when heated, but for practical brewing purposes, this effect is minimal and typically not accounted for in strike water calculations.
                </p>
                <p>
                    <strong>Q5: Can I use this calculator for different grain types?</strong><br>
                    A: Yes, the calculation works for any brewing grains including barley, wheat, rye, and other cereal grains used in brewing.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Calculator Brewing© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
