
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Calculator By Country</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Calculator By Country</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Footprint Equation:
                </p>
<div class="formula-container">
    \[ WF = direct + virtual\_water\_food + virtual\_water\_products + virtual\_water\_energy \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="direct" class="label-box">Direct Water Usage:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="direct" name="direct" step="0.0001" min="0" value="<?php echo isset($_POST['direct']) ? htmlspecialchars($_POST['direct']) : ''; ?>" required>
                                <span class="calc-input">gallons/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="virtual_water_food" class="label-box">Virtual Water Food:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="virtual_water_food" name="virtual_water_food" step="0.0001" min="0" value="<?php echo isset($_POST['virtual_water_food']) ? htmlspecialchars($_POST['virtual_water_food']) : ''; ?>" required>
                                <span class="calc-input">gallons/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="virtual_water_products" class="label-box">Virtual Water Products:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="virtual_water_products" name="virtual_water_products" step="0.0001" min="0" value="<?php echo isset($_POST['virtual_water_products']) ? htmlspecialchars($_POST['virtual_water_products']) : ''; ?>" required>
                                <span class="calc-input">gallons/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="virtual_water_energy" class="label-box">Virtual Water Energy:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="virtual_water_energy" name="virtual_water_energy" step="0.0001" min="0" value="<?php echo isset($_POST['virtual_water_energy']) ? htmlspecialchars($_POST['virtual_water_energy']) : ''; ?>" required>
                                <span class="calc-input">gallons/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['direct']) && 
                        isset($_POST['virtual_water_food']) &&
                        isset($_POST['virtual_water_products']) &&
                        isset($_POST['virtual_water_energy'])) {
                        
                        // Get input values
                        $direct = floatval($_POST['direct']);
                        $virtual_water_food = floatval($_POST['virtual_water_food']);
                        $virtual_water_products = floatval($_POST['virtual_water_products']);
                        $virtual_water_energy = floatval($_POST['virtual_water_energy']);

                        if ($direct >= 0 && $virtual_water_food >= 0 && $virtual_water_products >= 0 && $virtual_water_energy >= 0) {
                            // Calculate water footprint
                            $wf = $direct + $virtual_water_food + $virtual_water_products + $virtual_water_energy;
                            $wf = round($wf, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Footprint (WF):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($wf) ? htmlspecialchars($wf) . " gallons/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What Is Water Footprint Calculation?</a></li>
                    <li><a href="#section2">2. How Does The Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance Of Water Footprint Assessment</a></li>
                    <li><a href="#section4">4. Using The Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What Is Water Footprint Calculation?</h3>
                <p>
Water footprint calculation measures the total volume of freshwater used to produce the goods and services consumed by an individual, community, or business. It includes both direct water use and virtual water embedded in products.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does The Calculator Work?</h3>
                <p>
                    The calculator uses the water footprint equation:
                </p>
                <div class="formula-2-container">
                    \[ WF = direct + virtual\_water\_food + virtual\_water\_products + virtual\_water\_energy \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( direct \) — Direct water consumption (gallons/day)</li>
                        <li>\( virtual\_water\_food \) — Virtual water in food products (gallons/day)</li>
                        <li>\( virtual\_water\_products \) — Virtual water in non-food products (gallons/day)</li>
                        <li>\( virtual\_water\_energy \) — Virtual water in energy production (gallons/day)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> This comprehensive approach accounts for all water usage, including embedded water in imported goods and services.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance Of Water Footprint Assessment</h3>
                <p>
                    <strong>Details:</strong> Understanding water footprint helps in sustainable water resource management, identifying water-intensive processes, and making informed decisions about consumption patterns and trade.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using The Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter all water usage components in gallons per day. Values must be non-negative. For country-level calculations, use national average data for each component.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is virtual water?</strong><br>
                    A: Virtual water is the water embedded in products and services throughout their production chain, which may not be visible in the final product.
                </p>
                <p>
                    <strong>Q2: Why measure water footprint by country?</strong><br>
                    A: Country-level measurement helps understand water dependency, trade impacts, and sustainability of national water resources.
                </p>
                <p>
                    <strong>Q3: How accurate are these calculations?</strong><br>
                    A: Accuracy depends on the quality of input data. National statistics and life cycle assessment data provide the most reliable inputs.
                </p>
                <p>
                    <strong>Q4: What are typical water footprint values?</strong><br>
                    A: Water footprints vary significantly by country, ranging from about 500 to over 6000 gallons per person per day, depending on lifestyle and climate.
                </p>
                <p>
                    <strong>Q5: How can water footprint be reduced?</strong><br>
                    A: Reduction strategies include water-efficient technologies, changing consumption patterns, sustainable agricultural practices, and conscious product choices.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Calculator By Country© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
