
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Calculator For Brewing</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Calculator For Brewing</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Calculation Formula:
                </p>
<div class="formula-container">
    \[ water = grain \times ratio + losses \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="grain" class="label-box">Grain:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="grain" name="grain" step="0.01" min="0" value="<?php echo isset($_POST['grain']) ? htmlspecialchars($_POST['grain']) : ''; ?>" required>
                                <span class="calc-input">kg</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="ratio" class="label-box">Ratio:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="ratio" name="ratio" step="0.01" min="0" value="<?php echo isset($_POST['ratio']) ? htmlspecialchars($_POST['ratio']) : ''; ?>" required>
                                <span class="calc-input">L/kg</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="losses" class="label-box">Losses:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="losses" name="losses" step="0.01" min="0" value="<?php echo isset($_POST['losses']) ? htmlspecialchars($_POST['losses']) : ''; ?>" required>
                                <span class="calc-input">L</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['grain']) && 
                        isset($_POST['ratio']) &&
                        isset($_POST['losses'])) {
                        
                        // Get input values
                        $grain = floatval($_POST['grain']);
                        $ratio = floatval($_POST['ratio']);
                        $losses = floatval($_POST['losses']);

                        if ($grain >= 0 && $ratio >= 0 && $losses >= 0) {
                            // Calculate water using the formula
                            $water = $grain * $ratio + $losses;
                            $water = round($water, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($water) ? htmlspecialchars($water) . " L" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What Is The Water Calculation For Brewing?</a></li>
                    <li><a href="#section2">2. How Does The Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance Of Water Calculation In Brewing</a></li>
                    <li><a href="#section4">4. Using The Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What Is The Water Calculation For Brewing?</h3>
                <p>
The water calculation for brewing estimates the total water needed for the mashing process based on the amount of grain, the water-to-grain ratio, and expected losses during brewing.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does The Calculator Work?</h3>
                <p>
                    The calculator uses the formula:
                </p>
                <div class="formula-2-container">
                    \[ water = grain \times ratio + losses \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( grain \) — Amount of grain in kilograms (kg)</li>
                        <li>\( ratio \) — Water-to-grain ratio in liters per kilogram (L/kg)</li>
                        <li>\( losses \) — Expected water losses in liters (L)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> This formula calculates the total water needed by multiplying the grain amount by the desired ratio and adding any expected losses during the brewing process.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance Of Water Calculation In Brewing</h3>
                <p>
                    <strong>Details:</strong> Accurate water calculation is essential for achieving the desired mash consistency, proper starch conversion, and ultimately producing beer with the intended characteristics and quality.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using The Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the grain amount in kg, water-to-grain ratio in L/kg, and expected losses in L. All values must be non-negative numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is a typical water-to-grain ratio for brewing?</strong><br>
                    A: A common ratio is 2.5-3.0 L/kg, but this can vary based on the beer style and brewing system.
                </p>
                <p>
                    <strong>Q2: What types of losses should be considered?</strong><br>
                    A: Losses may include evaporation during boiling, absorption by grain, and system dead space.
                </p>
                <p>
                    <strong>Q3: Does water quality affect the brewing process?</strong><br>
                    A: Yes, water mineral content and pH significantly impact mash efficiency and final beer flavor.
                </p>
                <p>
                    <strong>Q4: Should sparge water be included in this calculation?</strong><br>
                    A: This calculation typically covers mash water only. Sparge water is usually calculated separately.
                </p>
                <p>
                    <strong>Q5: How accurate is this water calculation?</strong><br>
                    A: It provides a good estimate, but actual water needs may vary based on your specific equipment and process.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Calculator For Brewing© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
