
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Calculator For New Dwellings</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Calculator For New Dwellings</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Efficiency Formula:
                </p>
<div class="formula-container">
    \[ \text{total} = \sum(\text{fixture\_consumption}) + 5 \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="fixture_consumption" class="label-box">Fixture Consumption (l/person/day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="fixture_consumption" name="fixture_consumption" step="0.01" min="0" value="<?php echo isset($_POST['fixture_consumption']) ? htmlspecialchars($_POST['fixture_consumption']) : ''; ?>" required>
                                <span class="calc-input">l/person/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['fixture_consumption'])) {
                        
                        // Get input value
                        $fixture_consumption = floatval($_POST['fixture_consumption']);

                        if ($fixture_consumption >= 0) {
                            // Calculate total water consumption
                            $total = $fixture_consumption + 5;
                            $total = round($total, 2);
                            
                            // Check compliance
                            $compliant = ($total <= 125) ? "Yes" : "No";
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Total Water Consumption:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($total) ? htmlspecialchars($total) . " l/person/day" : ""; ?>' readonly>
                    </div>
                    <div class="result-box">
                        <label>Compliant with Part G (≤125 l/person/day):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($compliant) ? htmlspecialchars($compliant) : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Water Efficiency Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Efficiency</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Water Efficiency Calculation?</h3>
                <p>
The water efficiency calculation for new dwellings is required by Part G of building regulations. It ensures that water consumption does not exceed 125 liters per person per day, promoting sustainable water use in residential buildings.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the formula:
                </p>
                <div class="formula-2-container">
                    \[ \text{total} = \sum(\text{fixture\_consumption}) + 5 \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( \text{fixture\_consumption} \) — Total water consumption from all fixtures (l/person/day)</li>
                        <li>\( 5 \) — Allowance for external water use (l/person/day)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The calculation sums all fixture water consumption and adds a fixed allowance for external use to determine total water efficiency.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Efficiency</h3>
                <p>
                    <strong>Details:</strong> Meeting water efficiency standards is crucial for sustainable development, reducing water consumption, and complying with building regulations Part G requirements.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the total fixture consumption in liters per person per day. The calculator will add the 5 l/person/day external use allowance and check compliance with the 125 l/person/day limit.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is included in fixture consumption?</strong><br>
                    A: Fixture consumption includes water usage from toilets, showers, baths, taps, and any other water-using fixtures in the dwelling.
                </p>
                <p>
                    <strong>Q2: Why is there a 5 l/person/day external allowance?</strong><br>
                    A: This accounts for external water uses such as garden watering, car washing, and other outdoor water consumption.
                </p>
                <p>
                    <strong>Q3: What is the maximum allowable water consumption?</strong><br>
                    A: The total water consumption must not exceed 125 liters per person per day to comply with Part G regulations.
                </p>
                <p>
                    <strong>Q4: How is per person consumption calculated?</strong><br>
                    A: Consumption is calculated based on standard occupancy assumptions for the dwelling type and size.
                </p>
                <p>
                    <strong>Q5: Are there different requirements for different dwelling types?</strong><br>
                    A: The 125 l/person/day standard applies to all new dwellings, though calculation methods may vary slightly for different fixture types.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Calculator For New Dwellings© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>