
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Consumption Calculation Formula</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Consumption Calculation Formula</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Consumption Formula:
                </p>
<div class="formula-container">
    \[ Consumption = Population \times Per\ Capita\ Rate \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="population" class="label-box">Population:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="population" name="population" step="1" min="0" value="<?php echo isset($_POST['population']) ? htmlspecialchars($_POST['population']) : ''; ?>" required>
                                <span class="calc-input">people</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="per_capita_rate" class="label-box">Per Capita Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="per_capita_rate" name="per_capita_rate" step="0.01" min="0" value="<?php echo isset($_POST['per_capita_rate']) ? htmlspecialchars($_POST['per_capita_rate']) : ''; ?>" required>
                                <span class="calc-input">L/person/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['population']) && 
                        isset($_POST['per_capita_rate'])) {
                        
                        // Get input values
                        $population = floatval($_POST['population']);
                        $per_capita_rate = floatval($_POST['per_capita_rate']);

                        if ($population > 0 && $per_capita_rate > 0) {
                            // Calculate water consumption
                            $consumption = $population * $per_capita_rate;
                            $consumption = round($consumption, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Consumption:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($consumption) ? htmlspecialchars($consumption) . " L/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Water Consumption Formula?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Consumption Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Water Consumption Formula?</h3>
                <p>
The water consumption formula calculates total water usage by multiplying population size by the per capita water consumption rate. This provides an estimate of the total water demand for a given population.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water consumption formula:
                </p>
                <div class="formula-2-container">
                    \[ Consumption = Population \times Per\ Capita\ Rate \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Population \) — Number of people</li>
                        <li>\( Per\ Capita\ Rate \) — Water consumption per person per day (L/person/day)</li>
                        <li>\( Consumption \) — Total water consumption (L/day)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> This simple multiplication provides the total daily water consumption for a population based on individual usage rates.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Consumption Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water consumption calculation is crucial for urban planning, water resource management, infrastructure design, and ensuring adequate water supply for communities.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter population as a whole number and per capita rate in liters per person per day. Both values must be positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is a typical per capita water consumption rate?</strong><br>
                    A: Typical rates range from 80-300 L/person/day depending on location, climate, and lifestyle factors.
                </p>
                <p>
                    <strong>Q2: Does this formula account for commercial/industrial water use?</strong><br>
                    A: No, this formula calculates residential water consumption only. Commercial and industrial uses require separate calculations.
                </p>
                <p>
                    <strong>Q3: How does seasonality affect water consumption?</strong><br>
                    A: Water consumption typically increases during hot/dry seasons due to higher outdoor water use (gardening, pools, etc.).
                </p>
                <p>
                    <strong>Q4: What factors influence per capita water consumption?</strong><br>
                    A: Climate, water pricing, conservation measures, household appliances, and cultural habits all influence consumption rates.
                </p>
                <p>
                    <strong>Q5: How accurate is this estimation method?</strong><br>
                    A: This provides a good baseline estimate, but actual consumption may vary based on specific local conditions and measurement methods.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Consumption Calculation Formula© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>