
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Content Formula Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Content Formula Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Content Formula:
                </p>
<div class="formula-container">
    \[ MC (\%) = \frac{\text{Wet weight (g)} - \text{Dry weight (g)}}{\text{Wet weight (g)}} \times 100 \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="wet_weight" class="label-box">Wet Weight:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="wet_weight" name="wet_weight" step="0.0001" min="0" value="<?php echo isset($_POST['wet_weight']) ? htmlspecialchars($_POST['wet_weight']) : ''; ?>" required>
                                <span class="calc-input">grams</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="dry_weight" class="label-box">Dry Weight:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="dry_weight" name="dry_weight" step="0.0001" min="0" value="<?php echo isset($_POST['dry_weight']) ? htmlspecialchars($_POST['dry_weight']) : ''; ?>" required>
                                <span class="calc-input">grams</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['wet_weight']) && 
                        isset($_POST['dry_weight'])) {
                        
                        // Get input values
                        $wet_weight = floatval($_POST['wet_weight']);
                        $dry_weight = floatval($_POST['dry_weight']);

                        if ($wet_weight > 0 && $dry_weight > 0 && $wet_weight > $dry_weight) {
                            // Calculate moisture content percentage
                            $mc = (($wet_weight - $dry_weight) / $wet_weight) * 100;
                            $mc = round($mc, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Moisture Content (MC):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($mc) ? htmlspecialchars($mc) . " %" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Water Content Formula?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Moisture Content Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Water Content Formula?</h3>
                <p>
The Water Content Formula calculates the moisture content percentage in a substance by comparing its wet weight to its dry weight. This measurement is crucial in various fields including agriculture, food science, construction, and materials testing.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the moisture content formula:
                </p>
                <div class="formula-2-container">
                    \[ MC (\%) = \frac{\text{Wet weight} - \text{Dry weight}}{\text{Wet weight}} \times 100 \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( MC \) — Moisture Content (percentage)</li>
                        <li>\( Wet weight \) — Weight of the sample before drying (grams)</li>
                        <li>\( Dry weight \) — Weight of the sample after complete drying (grams)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula calculates what percentage of the original wet weight was water that evaporated during the drying process.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Moisture Content Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate moisture content measurement is essential for quality control in food production, determining shelf life, assessing soil conditions for construction, and ensuring proper material properties in manufacturing processes.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter both wet and dry weights in grams. Ensure the dry weight is less than the wet weight. Measurements should be precise for accurate results.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is considered a normal moisture content range?</strong><br>
                    A: Normal ranges vary greatly by material. Food products typically range from 5-15%, soils can range from 10-40%, while construction materials like wood may have 8-19% moisture content.
                </p>
                <p>
                    <strong>Q2: How is dry weight determined?</strong><br>
                    A: Dry weight is typically obtained by heating the sample in an oven at a specific temperature (usually 105°C for most materials) until constant weight is achieved.
                </p>
                <p>
                    <strong>Q3: Why is moisture content important in food products?</strong><br>
                    A: Moisture content affects food safety, texture, shelf life, and nutritional value. High moisture can promote microbial growth while low moisture can affect product quality.
                </p>
                <p>
                    <strong>Q4: Can this formula be used for all materials?</strong><br>
                    A: While the basic principle applies to most materials, some substances may require specialized drying techniques or calculations for accurate moisture content determination.
                </p>
                <p>
                    <strong>Q5: What units should be used for measurement?</strong><br>
                    A: While grams are commonly used, any consistent weight unit can be used as the formula calculates a percentage ratio that is unit-independent.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Content Formula Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
