
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Diet Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Diet Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Diet Formula:
                </p>
<div class="formula-container">
    \[ Water\ Intake = Weight\ (lbs) + 20\ oz/day \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="weight_lbs" class="label-box">Weight:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="weight_lbs" name="weight_lbs" step="0.1" min="0" value="<?php echo isset($_POST['weight_lbs']) ? htmlspecialchars($_POST['weight_lbs']) : ''; ?>" required>
                                <span class="calc-input">lb</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['weight_lbs'])) {
                        
                        // Get input values
                        $weight_lbs = floatval($_POST['weight_lbs']);

                        if ($weight_lbs > 0) {
                            // Calculate water intake
                            $ounces = $weight_lbs + 20;
                            $ounces = round($ounces, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Intake:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($ounces) ? htmlspecialchars($ounces) . " oz/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Water Diet Formula?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Proper Hydration</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Water Diet Formula?</h3>
                <p>
The Water Diet Formula calculates daily water intake based on body weight. It recommends drinking your body weight in pounds plus 20 ounces of water per day for optimal hydration.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the Water Diet Formula:
                </p>
                <div class="formula-2-container">
                    \[ Water\ Intake = Weight\ (lbs) + 20\ oz/day \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Weight \) — Body weight in pounds (lbs)</li>
                        <li>\( 20 \) — Additional ounces for optimal hydration</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> This formula provides a simple method to determine daily water intake requirements based on body weight with an additional 20 ounces for proper hydration.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Proper Hydration</h3>
                <p>
                    <strong>Details:</strong> Adequate water intake is essential for maintaining bodily functions, regulating temperature, supporting digestion, and promoting overall health and wellness.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter your weight in pounds. The calculator will determine your recommended daily water intake in ounces. All values must be valid (weight > 0).
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Why add 20 ounces to the weight?</strong><br>
                    A: The additional 20 ounces ensures adequate hydration beyond the basic weight-based requirement, accounting for daily activities and metabolic needs.
                </p>
                <p>
                    <strong>Q2: Is this formula suitable for everyone?</strong><br>
                    A: While this provides a general guideline, individual hydration needs may vary based on activity level, climate, and health conditions.
                </p>
                <p>
                    <strong>Q3: When should I drink more water?</strong><br>
                    A: Increase water intake during exercise, hot weather, illness, or when consuming diuretics like caffeine or alcohol.
                </p>
                <p>
                    <strong>Q4: Can I drink too much water?</strong><br>
                    A: While rare, overhydration (water intoxication) is possible. Listen to your body's signals and consult a healthcare provider for personalized advice.
                </p>
                <p>
                    <strong>Q5: How should I space out my water intake?</strong><br>
                    A: Distribute your water intake throughout the day rather than drinking large amounts at once for optimal hydration.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Diet Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>