
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Dilution Calculator Beer</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Dilution Calculator Beer</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Dilution Formula:
                </p>
<div class="formula-container">
    \[ \text{Final Volume} = \text{Initial Volume} \times \frac{\text{Initial Gravity}}{\text{Final Gravity}} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="initial_volume" class="label-box">Initial Volume:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="initial_volume" name="initial_volume" step="0.01" min="0" value="<?php echo isset($_POST['initial_volume']) ? htmlspecialchars($_POST['initial_volume']) : ''; ?>" required>
                                <span class="calc-input">L</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="initial_gravity" class="label-box">Initial Gravity:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="initial_gravity" name="initial_gravity" step="0.001" min="1.000" value="<?php echo isset($_POST['initial_gravity']) ? htmlspecialchars($_POST['initial_gravity']) : ''; ?>" required>
                                <span class="calc-input">SG</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="final_gravity" class="label-box">Final Gravity:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="final_gravity" name="final_gravity" step="0.001" min="1.000" value="<?php echo isset($_POST['final_gravity']) ? htmlspecialchars($_POST['final_gravity']) : ''; ?>" required>
                                <span class="calc-input">SG</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['initial_volume']) && 
                        isset($_POST['initial_gravity']) &&
                        isset($_POST['final_gravity'])) {
                        
                        // Get input values
                        $initial_volume = floatval($_POST['initial_volume']);
                        $initial_gravity = floatval($_POST['initial_gravity']);
                        $final_gravity = floatval($_POST['final_gravity']);

                        if ($initial_volume > 0 && $initial_gravity > 1.0 && $final_gravity > 1.0 && $final_gravity < $initial_gravity) {
                            // Calculate final volume using the dilution formula
                            $final_volume = $initial_volume * ($initial_gravity / $final_gravity);
                            $final_volume = round($final_volume, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Final Volume:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($final_volume) ? htmlspecialchars($final_volume) . " L" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What Is Water Dilution in Beer Brewing?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Proper Dilution</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What Is Water Dilution in Beer Brewing?</h3>
                <p>
Water dilution is a technique used in beer brewing to adjust the original gravity of wort by adding water. This process helps achieve the desired alcohol content and flavor profile in the final beer product.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water dilution formula:
                </p>
                <div class="formula-2-container">
                    \[ \text{Final Volume} = \text{Initial Volume} \times \frac{\text{Initial Gravity}}{\text{Final Gravity}} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( \text{Initial Volume} \) — Starting volume of wort (L)</li>
                        <li>\( \text{Initial Gravity} \) — Original specific gravity of wort (SG)</li>
                        <li>\( \text{Final Gravity} \) — Desired specific gravity after dilution (SG)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> This formula calculates how much water needs to be added to achieve your target gravity while maintaining the beer's characteristics.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Proper Dilution</h3>
                <p>
                    <strong>Details:</strong> Proper water dilution is crucial for achieving consistent alcohol content, balancing flavors, and ensuring the beer meets style guidelines. Incorrect dilution can lead to off-flavors or inconsistent batches.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter initial volume in liters, initial gravity and final gravity as specific gravity values. All values must be valid (volume > 0, initial gravity > final gravity > 1.000).
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: When should I dilute my beer?</strong><br>
                    A: Dilution is typically done before fermentation begins, but can also be done post-fermentation for high-gravity beers.
                </p>
                <p>
                    <strong>Q2: Does dilution affect beer flavor?</strong><br>
                    A: Yes, proper dilution maintains flavor balance. Over-dilution can make beer watery, while under-dilution can make it too strong.
                </p>
                <p>
                    <strong>Q3: What type of water should I use for dilution?</strong><br>
                    A: Always use purified, dechlorinated water that's appropriate for brewing to avoid introducing off-flavors.
                </p>
                <p>
                    <strong>Q4: Can I use this calculator for extract brewing?</strong><br>
                    A: Yes, this calculator works for both all-grain and extract brewing methods.
                </p>
                <p>
                    <strong>Q5: How accurate is this calculation?</strong><br>
                    A: The calculation is mathematically precise, but actual results may vary slightly due to temperature variations and measurement accuracy.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Dilution Calculator Beer© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
