
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Efficiency Calculator For New Dwellings Gov Uk</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Efficiency Calculator For New Dwellings Gov Uk</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Efficiency Formula:
                </p>
<div class="formula-container">
    \[ total = \sum(fixture\_consumption) + 5 \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="fixture_consumption" class="label-box">Fixture Consumption (l/person/day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="fixture_consumption" name="fixture_consumption" step="0.01" min="0" value="<?php echo isset($_POST['fixture_consumption']) ? htmlspecialchars($_POST['fixture_consumption']) : ''; ?>" required>
                                <span class="calc-input">l/person/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['fixture_consumption'])) {
                        
                        // Get input value
                        $fixture_consumption = floatval($_POST['fixture_consumption']);

                        if ($fixture_consumption >= 0) {
                            // Calculate total water efficiency
                            $total = $fixture_consumption + 5;
                            $total = round($total, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Total Water Efficiency (l/person/day):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($total) ? htmlspecialchars($total) . " l/person/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Water Efficiency Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Efficiency</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Water Efficiency Calculation?</h3>
                <p>
Water efficiency calculation for new dwellings is a requirement under UK government regulations. It helps determine the total water consumption per person per day to ensure sustainable water usage in residential buildings.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water efficiency formula:
                </p>
                <div class="formula-2-container">
                    \[ total = \sum(fixture\_consumption) + 5 \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( fixture\_consumption \) — Water consumption from fixtures (l/person/day)</li>
                        <li>5 — Additional water allowance (l/person/day)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates total water efficiency by summing fixture consumption and adding a standard 5 l/person/day allowance as per UK government guidelines.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Efficiency</h3>
                <p>
                    <strong>Details:</strong> Calculating water efficiency is crucial for sustainable building design, compliance with UK building regulations, and reducing environmental impact through responsible water usage.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the total fixture water consumption in liters per person per day. The value must be a valid non-negative number.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is the purpose of the +5 l/person/day allowance?</strong><br>
                    A: This additional allowance accounts for miscellaneous water usage not covered by standard fixture calculations, ensuring realistic water efficiency assessments.
                </p>
                <p>
                    <strong>Q2: What are typical water efficiency targets?</strong><br>
                    A: UK building regulations typically target 125 l/person/day or less for new dwellings, though specific requirements may vary by local authority.
                </p>
                <p>
                    <strong>Q3: What fixtures are included in the calculation?</strong><br>
                    A: All water-using fixtures including toilets, showers, baths, taps, and appliances should be included in the fixture consumption calculation.
                </p>
                <p>
                    <strong>Q4: Is this calculator applicable to all UK regions?</strong><br>
                    A: While based on UK government guidelines, specific requirements may vary slightly between England, Wales, Scotland, and Northern Ireland.
                </p>
                <p>
                    <strong>Q5: How often should water efficiency be calculated?</strong><br>
                    A: Water efficiency calculations should be performed during the design phase of new dwellings and verified upon completion to ensure compliance.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Efficiency Calculator For New Dwellings Gov Uk© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>