
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Fasting Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Fasting Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Fasting Formula:
                </p>
<div class="formula-container">
    \[ \text{Loss (lb)} = \frac{\text{BMR (cal/day)} \times \text{days (days)}}{3500} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="bmr" class="label-box">BMR (cal/day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="bmr" name="bmr" step="0.01" min="0" value="<?php echo isset($_POST['bmr']) ? htmlspecialchars($_POST['bmr']) : ''; ?>" required>
                                <span class="calc-input">cal/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="days" class="label-box">Days:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="days" name="days" step="0.01" min="0" value="<?php echo isset($_POST['days']) ? htmlspecialchars($_POST['days']) : ''; ?>" required>
                                <span class="calc-input">days</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['bmr']) && 
                        isset($_POST['days'])) {
                        
                        // Get input values
                        $bmr = floatval($_POST['bmr']);
                        $days = floatval($_POST['days']);

                        if ($bmr > 0 && $days > 0) {
                            // Calculate weight loss using the formula
                            $loss = ($bmr * $days) / 3500;
                            $loss = round($loss, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Weight Loss (lb):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($loss) ? htmlspecialchars($loss) . " lb" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Water Fasting?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Weight Loss Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Water Fasting?</h3>
                <p>
Water fasting is a type of fasting where only water is consumed for a specific period. It's often used for weight loss, detoxification, and various health benefits. This calculator estimates the expected weight loss during a water fast.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water fasting formula:
                </p>
                <div class="formula-2-container">
                    \[ \text{Loss (lb)} = \frac{\text{BMR (cal/day)} \times \text{days (days)}}{3500} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( \text{BMR} \) — Basal Metabolic Rate (calories per day)</li>
                        <li>\( \text{days} \) — Duration of water fast (days)</li>
                        <li>3500 — Calories equivalent to 1 pound of body weight</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula calculates weight loss based on the calorie deficit created by consuming only water, using the principle that 3500 calories deficit equals approximately 1 pound of weight loss.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Weight Loss Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate weight loss estimation helps individuals set realistic expectations and plan their fasting duration accordingly. It provides a scientific basis for predicting results from water fasting.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter your BMR in calories per day and the planned duration of your water fast in days. Both values must be positive numbers for accurate calculation.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is BMR and how do I calculate it?</strong><br>
                    A: BMR (Basal Metabolic Rate) is the number of calories your body needs at rest. Various online calculators can help estimate your BMR based on age, gender, weight, and height.
                </p>
                <p>
                    <strong>Q2: Is this calculation accurate for everyone?</strong><br>
                    A: While the formula provides a good estimate, individual results may vary due to factors like metabolism, activity level, and body composition.
                </p>
                <p>
                    <strong>Q3: Is water fasting safe?</strong><br>
                    A: Water fasting should be approached with caution and preferably under medical supervision, especially for extended periods. Consult a healthcare professional before starting any fasting regimen.
                </p>
                <p>
                    <strong>Q4: What other factors affect weight loss during fasting?</strong><br>
                    A: Initial water weight loss, metabolic adaptation, and individual physiological differences can affect actual weight loss results.
                </p>
                <p>
                    <strong>Q5: Should I use this calculator for long-term fasting?</strong><br>
                    A: This calculator provides estimates, but for extended fasts, individual metabolic changes may make the calculation less accurate over time.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Fasting Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>