
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Fasting Weight Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Fasting Weight Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Weight Loss Equation:
                </p>
<div class="formula-container">
    \[ \text{Weight Loss (lbs)} = \frac{\text{BMR (kcal/day)} \times \text{Days}}{3500} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="bmr" class="label-box">BMR (Basal Metabolic Rate):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="bmr" name="bmr" step="0.01" min="0" value="<?php echo isset($_POST['bmr']) ? htmlspecialchars($_POST['bmr']) : ''; ?>" required>
                                <span class="calc-input">kcal/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="days" class="label-box">Days:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="days" name="days" step="0.01" min="0" value="<?php echo isset($_POST['days']) ? htmlspecialchars($_POST['days']) : ''; ?>" required>
                                <span class="calc-input">days</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['bmr']) && 
                        isset($_POST['days'])) {
                        
                        // Get input values
                        $bmr = floatval($_POST['bmr']);
                        $days = floatval($_POST['days']);

                        if ($bmr > 0 && $days > 0) {
                            // Calculate weight loss using the formula
                            $weight_loss = ($bmr * $days) / 3500;
                            $weight_loss = round($weight_loss, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Weight Loss:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($weight_loss) ? htmlspecialchars($weight_loss) . " lbs" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Water Fasting Weight Loss?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Weight Loss Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Water Fasting Weight Loss?</h3>
                <p>
Water fasting weight loss refers to the amount of weight an individual can expect to lose during a period of consuming only water. The calculation is based on the principle that one pound of body weight is equivalent to approximately 3500 calories.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the weight loss equation:
                </p>
                <div class="formula-2-container">
                    \[ \text{Weight Loss (lbs)} = \frac{\text{BMR (kcal/day)} \times \text{Days}}{3500} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( \text{BMR} \) — Basal Metabolic Rate (calories burned at rest per day)</li>
                        <li>\( \text{Days} \) — Number of fasting days</li>
                        <li>\( 3500 \) — Calories equivalent to one pound of body weight</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates expected weight loss by determining the total calorie deficit (BMR × Days) and converting it to pounds using the 3500 calories per pound conversion factor.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Weight Loss Calculation</h3>
                <p>
                    <strong>Details:</strong> Understanding potential weight loss during water fasting helps individuals set realistic expectations, plan their fasting duration, and monitor progress effectively.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter your Basal Metabolic Rate (BMR) in kcal/day and the number of fasting days. Both values must be positive numbers for accurate calculation.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is Basal Metabolic Rate (BMR)?</strong><br>
                    A: BMR is the number of calories your body needs to perform basic life-sustaining functions at rest, such as breathing, circulation, and cell production.
                </p>
                <p>
                    <strong>Q2: Is this calculation accurate for everyone?</strong><br>
                    A: While the 3500 calories per pound rule is a general guideline, individual results may vary based on metabolism, activity level, and other factors.
                </p>
                <p>
                    <strong>Q3: Should I consult a doctor before water fasting?</strong><br>
                    A: Yes, water fasting can have significant health implications. Always consult with a healthcare professional before beginning any extended fasting regimen.
                </p>
                <p>
                    <strong>Q4: What other factors affect weight loss during fasting?</strong><br>
                    A: Initial water weight loss, metabolic adaptation, physical activity, and individual metabolic differences can all influence actual weight loss results.
                </p>
                <p>
                    <strong>Q5: Is water fasting safe for everyone?</strong><br>
                    A: No, water fasting is not recommended for pregnant women, individuals with certain medical conditions, or those taking specific medications without medical supervision.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Fasting Weight Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
