
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Footprint Calculator For Food</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Footprint Calculator For Food</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Footprint Formula:
                </p>
<div class="formula-container">
    \[ WF = \sum (food\_consumption \times water\_per\_unit) \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="food_consumption" class="label-box">Food Consumption:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="food_consumption" name="food_consumption" step="0.0001" min="0" value="<?php echo isset($_POST['food_consumption']) ? htmlspecialchars($_POST['food_consumption']) : ''; ?>" required>
                                <span class="calc-input">kg/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="water_per_unit" class="label-box">Water Per Unit:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="water_per_unit" name="water_per_unit" step="0.0001" min="0" value="<?php echo isset($_POST['water_per_unit']) ? htmlspecialchars($_POST['water_per_unit']) : ''; ?>" required>
                                <span class="calc-input">L/kg</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['food_consumption']) && 
                        isset($_POST['water_per_unit'])) {
                        
                        // Get input values
                        $food_consumption = floatval($_POST['food_consumption']);
                        $water_per_unit = floatval($_POST['water_per_unit']);

                        if ($food_consumption > 0 && $water_per_unit > 0) {
                            // Calculate water footprint
                            $wf = $food_consumption * $water_per_unit;
                            $wf = round($wf, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Footprint (WF):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($wf) ? htmlspecialchars($wf) . " L/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Water Footprint For Food?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Footprint Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Water Footprint For Food?</h3>
                <p>
The Water Footprint for Food measures the total volume of freshwater used to produce a given quantity of food. It accounts for both direct and indirect water consumption throughout the production chain, providing insight into the water resources required for food items.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water footprint formula:
                </p>
                <div class="formula-2-container">
                    \[ WF = \sum (food\_consumption \times water\_per\_unit) \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( WF \) — Water Footprint (L/day)</li>
                        <li>\( food\_consumption \) — Amount of food consumed (kg/day)</li>
                        <li>\( water\_per\_unit \) — Water required per unit of food (L/kg)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates the total water consumption by multiplying the daily food consumption by the water required to produce each kilogram of that food.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Footprint Calculation</h3>
                <p>
                    <strong>Details:</strong> Calculating water footprint helps in understanding the environmental impact of food choices, promoting water conservation, and making sustainable dietary decisions.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter food consumption in kg/day and water per unit in L/kg. Both values must be positive numbers to get a valid result.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Why is water footprint important for food?</strong><br>
                    A: It helps quantify the water resources needed for food production, highlighting the environmental impact and encouraging more sustainable consumption patterns.
                </p>
                <p>
                    <strong>Q2: What are typical water footprint values for common foods?</strong><br>
                    A: Water footprints vary significantly - for example, beef requires about 15,000 L/kg while vegetables may require 200-300 L/kg.
                </p>
                <p>
                    <strong>Q3: How can I reduce my food water footprint?</strong><br>
                    A: Choose foods with lower water requirements, reduce food waste, and opt for locally produced seasonal items.
                </p>
                <p>
                    <strong>Q4: Does this include all types of water usage?</strong><br>
                    A: Yes, it includes blue water (surface and groundwater), green water (rainwater), and grey water (polluted water) throughout the production chain.
                </p>
                <p>
                    <strong>Q5: Are there limitations to water footprint calculations?</strong><br>
                    A: While useful, water footprint doesn't account for regional water scarcity differences and should be considered alongside other environmental metrics.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Footprint Calculator For Food© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>