
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Footprint Calculator For Students</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Footprint Calculator For Students</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Footprint Equation:
                </p>
<div class="formula-container">
    \[ WF = direct + virtual\_education + virtual\_food \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="direct" class="label-box">Direct Water Usage:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="direct" name="direct" step="0.01" min="0" value="<?php echo isset($_POST['direct']) ? htmlspecialchars($_POST['direct']) : ''; ?>" required>
                                <span class="calc-input">gallons/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="virtual_education" class="label-box">Virtual Education Water:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="virtual_education" name="virtual_education" step="0.01" min="0" value="<?php echo isset($_POST['virtual_education']) ? htmlspecialchars($_POST['virtual_education']) : ''; ?>" required>
                                <span class="calc-input">gallons/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="virtual_food" class="label-box">Virtual Food Water:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="virtual_food" name="virtual_food" step="0.01" min="0" value="<?php echo isset($_POST['virtual_food']) ? htmlspecialchars($_POST['virtual_food']) : ''; ?>" required>
                                <span class="calc-input">gallons/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['direct']) && 
                        isset($_POST['virtual_education']) &&
                        isset($_POST['virtual_food'])) {
                        
                        // Get input values
                        $direct = floatval($_POST['direct']);
                        $virtual_education = floatval($_POST['virtual_education']);
                        $virtual_food = floatval($_POST['virtual_food']);

                        if ($direct >= 0 && $virtual_education >= 0 && $virtual_food >= 0) {
                            // Calculate Water Footprint
                            $wf = $direct + $virtual_education + $virtual_food;
                            $wf = round($wf, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Footprint (WF):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($wf) ? htmlspecialchars($wf) . " gallons/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Water Footprint Calculator For Students?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Footprint Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Water Footprint Calculator For Students?</h3>
                <p>
The Water Footprint Calculator For Students estimates the total water usage including direct consumption and virtual water usage in education and food-related activities. It helps students understand their water consumption patterns and environmental impact.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water footprint equation:
                </p>
                <div class="formula-2-container">
                    \[ WF = direct + virtual\_education + virtual\_food \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( direct \) — Direct water usage (gallons/day)</li>
                        <li>\( virtual\_education \) — Virtual water usage for education (gallons/day)</li>
                        <li>\( virtual\_food \) — Virtual water usage for food (gallons/day)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates the total water footprint by summing direct water consumption and virtual water usage in educational and food-related activities.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Footprint Calculation</h3>
                <p>
                    <strong>Details:</strong> Understanding water footprint is crucial for environmental awareness, sustainable resource management, and making informed decisions about water consumption habits.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter direct water usage, virtual education water, and virtual food water in gallons/day. All values must be non-negative numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is considered direct water usage?</strong><br>
                    A: Direct water usage includes water consumed directly for drinking, bathing, washing, and other personal uses.
                </p>
                <p>
                    <strong>Q2: What is virtual water in education?</strong><br>
                    A: Virtual education water includes water used in the production of educational materials, school infrastructure, and educational activities.
                </p>
                <p>
                    <strong>Q3: What is virtual water in food?</strong><br>
                    A: Virtual food water includes water used in the production, processing, and transportation of food products consumed.
                </p>
                <p>
                    <strong>Q4: Why is water footprint important for students?</strong><br>
                    A: It helps students understand their environmental impact and promotes sustainable water consumption habits from an early age.
                </p>
                <p>
                    <strong>Q5: How can students reduce their water footprint?</strong><br>
                    A: By conserving direct water usage, choosing sustainable food options, and being mindful of resource consumption in educational activities.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Footprint Calculator For Students© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>