
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Footprint Calculator UK</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Footprint Calculator UK</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Footprint Equation:
                </p>
<div class="formula-container">
    \[ WF = Direct + Virtual\_Water\_Food + Virtual\_Water\_Products + Virtual\_Water\_Energy \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="direct" class="label-box">Direct Water Usage:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="direct" name="direct" step="0.01" min="0" value="<?php echo isset($_POST['direct']) ? htmlspecialchars($_POST['direct']) : ''; ?>" required>
                                <span class="calc-input">gallons/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="virtual_water_food" class="label-box">Virtual Water Food:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="virtual_water_food" name="virtual_water_food" step="0.01" min="0" value="<?php echo isset($_POST['virtual_water_food']) ? htmlspecialchars($_POST['virtual_water_food']) : ''; ?>" required>
                                <span class="calc-input">gallons/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="virtual_water_products" class="label-box">Virtual Water Products:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="virtual_water_products" name="virtual_water_products" step="0.01" min="0" value="<?php echo isset($_POST['virtual_water_products']) ? htmlspecialchars($_POST['virtual_water_products']) : ''; ?>" required>
                                <span class="calc-input">gallons/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="virtual_water_energy" class="label-box">Virtual Water Energy:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="virtual_water_energy" name="virtual_water_energy" step="0.01" min="0" value="<?php echo isset($_POST['virtual_water_energy']) ? htmlspecialchars($_POST['virtual_water_energy']) : ''; ?>" required>
                                <span class="calc-input">gallons/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['direct']) && 
                        isset($_POST['virtual_water_food']) &&
                        isset($_POST['virtual_water_products']) &&
                        isset($_POST['virtual_water_energy'])) {
                        
                        // Get input values
                        $direct = floatval($_POST['direct']);
                        $virtual_water_food = floatval($_POST['virtual_water_food']);
                        $virtual_water_products = floatval($_POST['virtual_water_products']);
                        $virtual_water_energy = floatval($_POST['virtual_water_energy']);

                        if ($direct >= 0 && $virtual_water_food >= 0 && $virtual_water_products >= 0 && $virtual_water_energy >= 0) {
                            // Calculate Water Footprint
                            $wf = $direct + $virtual_water_food + $virtual_water_products + $virtual_water_energy;
                            $wf = round($wf, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Footprint (WF):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($wf) ? htmlspecialchars($wf) . " gallons/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Water Footprint?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Footprint Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Water Footprint?</h3>
                <p>
Water Footprint measures the total volume of freshwater used to produce the goods and services consumed by an individual, community, or business. It includes both direct water use and virtual water embedded in products.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the Water Footprint equation:
                </p>
                <div class="formula-2-container">
                    \[ WF = Direct + Virtual\_Water\_Food + Virtual\_Water\_Products + Virtual\_Water\_Energy \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Direct \) — Direct water usage (gallons/day)</li>
                        <li>\( Virtual\_Water\_Food \) — Virtual water in food consumption (gallons/day)</li>
                        <li>\( Virtual\_Water\_Products \) — Virtual water in products (gallons/day)</li>
                        <li>\( Virtual\_Water\_Energy \) — Virtual water in energy production (gallons/day)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> This equation provides a comprehensive measure of water consumption by accounting for both direct usage and indirect water embedded in various consumption categories.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Footprint Calculation</h3>
                <p>
                    <strong>Details:</strong> Understanding water footprint helps in sustainable water management, identifying water-intensive consumption patterns, and making informed decisions to reduce overall water usage.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter all water usage values in gallons/day. Ensure values are non-negative. The calculator will sum all components to provide your total water footprint.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is virtual water?</strong><br>
                    A: Virtual water refers to the hidden water used in the production and transportation of goods and services that consumers buy and use.
                </p>
                <p>
                    <strong>Q2: Why measure water footprint in the UK context?</strong><br>
                    A: The UK imports many water-intensive products, making it important to understand the total water impact of consumption patterns, including imported virtual water.
                </p>
                <p>
                    <strong>Q3: What are typical water footprint values?</strong><br>
                    A: An average UK resident has a water footprint of approximately 4,645 liters per day (about 1,225 gallons/day), including both direct and virtual water usage.
                </p>
                <p>
                    <strong>Q4: How can I reduce my water footprint?</strong><br>
                    A: Reduce meat consumption, choose local and seasonal products, minimize food waste, and use water-efficient appliances to lower both direct and virtual water usage.
                </p>
                <p>
                    <strong>Q5: Are there limitations to this calculation?</strong><br>
                    A: This provides an estimate based on standard values. Actual virtual water content can vary based on production methods, transportation, and other factors.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Footprint Calculator UK© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>