
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water GPM Calculator Pipe Size</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water GPM Calculator Pipe Size</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    GPM Formula:
                </p>
<div class="formula-container">
    \[ GPM = \frac{\pi \times r^2 \times \text{velocity}}{0.408} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="radius" class="label-box">Pipe Radius (r):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="radius" name="radius" step="0.0001" min="0" value="<?php echo isset($_POST['radius']) ? htmlspecialchars($_POST['radius']) : ''; ?>" required>
                                <span class="calc-input">in</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="velocity" class="label-box">Velocity:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="velocity" name="velocity" step="0.0001" min="0" value="<?php echo isset($_POST['velocity']) ? htmlspecialchars($_POST['velocity']) : ''; ?>" required>
                                <span class="calc-input">ft/s</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['radius']) && 
                        isset($_POST['velocity'])) {
                        
                        // Get input values
                        $radius = floatval($_POST['radius']);
                        $velocity = floatval($_POST['velocity']);

                        if ($radius > 0 && $velocity > 0) {
                            // Calculate GPM using the formula
                            $gpm = (M_PI * pow($radius, 2) * $velocity) / 0.408;
                            $gpm = round($gpm, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Flow Rate (GPM):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($gpm) ? htmlspecialchars($gpm) . " gal/min" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the GPM Formula?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Flow Rate Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the GPM Formula?</h3>
                <p>
The GPM (Gallons Per Minute) formula calculates the flow rate of water through a pipe based on the pipe's cross-sectional area and the velocity of the water. It is commonly used in plumbing, irrigation, and hydraulic engineering.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the GPM formula:
                </p>
                <div class="formula-2-container">
                    \[ GPM = \frac{\pi \times r^2 \times \text{velocity}}{0.408} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( r \) — Pipe radius (inches)</li>
                        <li>\( \pi \) — Mathematical constant (approximately 3.14159)</li>
                        <li>velocity — Water velocity (feet per second)</li>
                        <li>0.408 — Conversion factor to get gallons per minute</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula calculates the cross-sectional area of the pipe, multiplies it by the velocity to get volume flow, and converts it to gallons per minute.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Flow Rate Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate flow rate calculation is essential for designing efficient water systems, ensuring proper pipe sizing, maintaining adequate pressure, and optimizing system performance in various applications.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter pipe radius in inches and water velocity in feet per second. All values must be positive numbers for accurate calculation.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Why is the conversion factor 0.408?</strong><br>
                    A: The factor 0.408 converts cubic feet per second to gallons per minute, accounting for the relationship between these units.
                </p>
                <p>
                    <strong>Q2: What is a typical water velocity in pipes?</strong><br>
                    A: Typical water velocities range from 2-8 ft/s, with 5 ft/s being a common design value for many applications.
                </p>
                <p>
                    <strong>Q3: Does this formula work for all fluids?</strong><br>
                    A: This specific formula is designed for water. Other fluids would require adjustments for different densities and viscosities.
                </p>
                <p>
                    <strong>Q4: How does pipe material affect flow rate?</strong><br>
                    A: Pipe material affects friction loss, which can impact velocity and ultimately flow rate. This formula assumes ideal conditions without friction loss.
                </p>
                <p>
                    <strong>Q5: Can I use diameter instead of radius?</strong><br>
                    A: Yes, but you would need to adjust the formula: GPM = (π × (d/2)² × velocity) / 0.408, where d is the diameter.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water GPM Calculator Pipe Size© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
