
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Intake Calculator Singapore</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Intake Calculator Singapore</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Intake Formula:
                </p>
<div class="formula-container">
    \[ Water\ Intake = Weight\ (kg) \times 0.03 \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="weight_kg" class="label-box">Weight:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="weight_kg" name="weight_kg" step="0.1" min="0" value="<?php echo isset($_POST['weight_kg']) ? htmlspecialchars($_POST['weight_kg']) : ''; ?>" required>
                                <span class="calc-input">kg</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['weight_kg'])) {
                        
                        // Get input values
                        $weight_kg = floatval($_POST['weight_kg']);

                        if ($weight_kg > 0) {
                            // Calculate water intake
                            $water_intake = $weight_kg * 0.03;
                            $water_intake = round($water_intake, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Recommended Water Intake:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($water_intake) ? htmlspecialchars($water_intake) . " L/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Water Intake Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Proper Hydration</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Water Intake Calculation?</h3>
                <p>
The water intake calculation provides an estimate of daily water requirements based on body weight using the standard Singapore guideline of 0.03 liters per kilogram of body weight.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the formula:
                </p>
                <div class="formula-2-container">
                    \[ Water\ Intake = Weight\ (kg) \times 0.03 \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Weight \) — Body weight in kilograms (kg)</li>
                        <li>\( 0.03 \) — Standard Singapore water intake coefficient (L/kg)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> This formula provides a general guideline for daily water consumption based on body weight, following Singapore health recommendations.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Proper Hydration</h3>
                <p>
                    <strong>Details:</strong> Adequate water intake is essential for maintaining proper bodily functions, regulating body temperature, supporting digestion, and promoting overall health. Proper hydration is particularly important in Singapore's tropical climate.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter your weight in kilograms. The result will show the recommended daily water intake in liters. This is a general guideline; individual needs may vary based on activity level, climate, and health conditions.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Is this calculation specific to Singapore?</strong><br>
                    A: Yes, this uses the standard Singapore guideline of 0.03 liters per kilogram of body weight for daily water intake.
                </p>
                <p>
                    <strong>Q2: Should I drink more water in hot weather?</strong><br>
                    A: Yes, in Singapore's tropical climate, you may need additional water to compensate for increased perspiration.
                </p>
                <p>
                    <strong>Q3: Does this include water from food and other beverages?</strong><br>
                    A: This calculation represents total fluid needs, which can be met through drinking water, other beverages, and water-rich foods.
                </p>
                <p>
                    <strong>Q4: Are there situations where I might need more water?</strong><br>
                    A: Yes, during exercise, illness, pregnancy, or breastfeeding, your water requirements may increase.
                </p>
                <p>
                    <strong>Q5: Can I drink too much water?</strong><br>
                    A: While rare, it is possible to overhydrate. Most healthy kidneys can process up to 0.8-1.0 liters per hour. Consult a healthcare provider for personalized advice.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Intake Calculator Singapore© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
