
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Potential Formula Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Potential Formula Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Potential Equation:
                </p>
<div class="formula-container">
    \[ \Psi = \Psi_s + \Psi_p + \Psi_g \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="psi_s" class="label-box">Solute Potential (Ψ_s):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="psi_s" name="psi_s" step="0.0001" value="<?php echo isset($_POST['psi_s']) ? htmlspecialchars($_POST['psi_s']) : ''; ?>" required>
                                <span class="calc-input">MPa</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="psi_p" class="label-box">Pressure Potential (Ψ_p):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="psi_p" name="psi_p" step="0.0001" value="<?php echo isset($_POST['psi_p']) ? htmlspecialchars($_POST['psi_p']) : ''; ?>" required>
                                <span class="calc-input">MPa</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="psi_g" class="label-box">Gravitational Potential (Ψ_g):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="psi_g" name="psi_g" step="0.0001" value="<?php echo isset($_POST['psi_g']) ? htmlspecialchars($_POST['psi_g']) : ''; ?>" required>
                                <span class="calc-input">MPa</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['psi_s']) && 
                        isset($_POST['psi_p']) &&
                        isset($_POST['psi_g'])) {
                        
                        // Get input values
                        $psi_s = floatval($_POST['psi_s']);
                        $psi_p = floatval($_POST['psi_p']);
                        $psi_g = floatval($_POST['psi_g']);

                        // Calculate water potential
                        $psi = $psi_s + $psi_p + $psi_g;
                        $psi = round($psi, 4);
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Potential (Ψ):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($psi) ? htmlspecialchars($psi) . " MPa" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Water Potential Formula?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Potential Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Water Potential Formula?</h3>
                <p>
The water potential equation (Ψ = Ψ_s + Ψ_p + Ψ_g) represents the total potential energy of water in a system. It's a fundamental concept in plant physiology and soil science that describes the tendency of water to move from one area to another.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water potential equation:
                </p>
                <div class="formula-2-container">
                    \[ \Psi = \Psi_s + \Psi_p + \Psi_g \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( \Psi \) — Total water potential (MPa)</li>
                        <li>\( \Psi_s \) — Solute potential (osmotic potential) (MPa)</li>
                        <li>\( \Psi_p \) — Pressure potential (MPa)</li>
                        <li>\( \Psi_g \) — Gravitational potential (MPa)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation sums all components that contribute to water's energy state, with water moving from areas of higher potential to lower potential.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Potential Calculation</h3>
                <p>
                    <strong>Details:</strong> Water potential calculations are crucial for understanding water movement in plants, predicting plant water status, irrigation management, and studying soil-plant-atmosphere continuum.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter all three potential components in MPa units. The calculator will sum them to give the total water potential. Negative values are common for solute potential.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What are typical values for water potential components?</strong><br>
                    A: Ψ_s is typically negative (-0.5 to -2.5 MPa in plants), Ψ_p can be positive (turgor pressure) or negative, Ψ_g is usually small except in tall trees.
                </p>
                <p>
                    <strong>Q2: Why is water potential measured in MPa?</strong><br>
                    A: Megapascals (MPa) are the standard SI unit for water potential, providing convenient scale for biological systems (1 MPa = 10 bars).
                </p>
                <p>
                    <strong>Q3: How does water potential affect plant water movement?</strong><br>
                    A: Water always moves from areas of higher water potential to areas of lower water potential, driving water uptake and transport in plants.
                </p>
                <p>
                    <strong>Q4: What factors influence solute potential?</strong><br>
                    A: Solute concentration primarily determines Ψ_s - higher solute concentration results in more negative solute potential.
                </p>
                <p>
                    <strong>Q5: When is gravitational potential significant?</strong><br>
                    A: Ψ_g becomes important in tall trees (approximately 0.01 MPa per 1 meter height) and in soil water movement calculations.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Potential Formula Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
