
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Pressure Formula Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Pressure Formula Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Pressure Formula:
                </p>
<div class="formula-container">
    \[ P = \rho \times g \times h \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="density" class="label-box">Density (ρ):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="density" name="density" step="0.0001" min="0" value="<?php echo isset($_POST['density']) ? htmlspecialchars($_POST['density']) : '1000'; ?>" required>
                                <span class="calc-input">kg/m³</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="gravity" class="label-box">Gravity (g):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="gravity" name="gravity" step="0.0001" min="0" value="<?php echo isset($_POST['gravity']) ? htmlspecialchars($_POST['gravity']) : '9.81'; ?>" required>
                                <span class="calc-input">m/s²</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="height" class="label-box">Height (h):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="height" name="height" step="0.0001" min="0" value="<?php echo isset($_POST['height']) ? htmlspecialchars($_POST['height']) : ''; ?>" required>
                                <span class="calc-input">m</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['density']) && 
                        isset($_POST['gravity']) &&
                        isset($_POST['height'])) {
                        
                        // Get input values
                        $density = floatval($_POST['density']);
                        $gravity = floatval($_POST['gravity']);
                        $height = floatval($_POST['height']);

                        if ($density > 0 && $gravity > 0 && $height > 0) {
                            // Calculate water pressure using the formula P = ρ * g * h
                            $pressure = $density * $gravity * $height;
                            $pressure = round($pressure, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Pressure (P):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($pressure) ? htmlspecialchars($pressure) . " Pa" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Water Pressure Formula?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Pressure Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Water Pressure Formula?</h3>
                <p>
The water pressure formula calculates the pressure exerted by a column of water at a certain depth. It is derived from the fundamental principle of fluid mechanics and is essential for various engineering and scientific applications.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water pressure formula:
                </p>
                <div class="formula-2-container">
                    \[ P = \rho \times g \times h \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( P \) — Water pressure (Pascal)</li>
                        <li>\( \rho \) — Density of water (kg/m³)</li>
                        <li>\( g \) — Acceleration due to gravity (m/s²)</li>
                        <li>\( h \) — Height/depth of water column (m)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula calculates the pressure at the bottom of a water column based on the density of water, gravitational acceleration, and the height of the water column.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Pressure Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water pressure calculation is crucial for designing hydraulic systems, dams, pipelines, and underwater structures. It helps engineers ensure structural integrity and proper functioning of water-related systems.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter water density in kg/m³ (default 1000 for pure water), gravity in m/s² (default 9.81 for Earth), and height/depth in meters. All values must be positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is the standard density of water?</strong><br>
                    A: The standard density of pure water at 4°C is 1000 kg/m³. Density may vary with temperature and salinity.
                </p>
                <p>
                    <strong>Q2: Does gravity vary by location?</strong><br>
                    A: Yes, gravitational acceleration varies slightly by location on Earth, but 9.81 m/s² is the standard value used for most calculations.
                </p>
                <p>
                    <strong>Q3: What units are used for water pressure?</strong><br>
                    A: The SI unit for pressure is Pascal (Pa), but other common units include bar, psi, and atmospheres. This calculator uses Pascals.
                </p>
                <p>
                    <strong>Q4: Does this formula work for other fluids?</strong><br>
                    A: Yes, the formula P = ρ * g * h works for any fluid, but you must use the correct density value for that specific fluid.
                </p>
                <p>
                    <strong>Q5: How does water pressure change with depth?</strong><br>
                    A: Water pressure increases linearly with depth. For every meter of depth, pressure increases by approximately 9810 Pa in fresh water.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Pressure Formula Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
