
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Proof Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Proof Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Proofing Formula:
                </p>
<div class="formula-container">
    \[ \text{Proof (\%)} = \frac{\text{Initial Volume (l)} - \text{Final Volume (l)}}{\text{Initial Volume (l)}} \times 100 \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="initial_volume" class="label-box">Initial Volume:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="initial_volume" name="initial_volume" step="0.0001" min="0" value="<?php echo isset($_POST['initial_volume']) ? htmlspecialchars($_POST['initial_volume']) : ''; ?>" required>
                                <span class="calc-input">liters</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="final_volume" class="label-box">Final Volume:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="final_volume" name="final_volume" step="0.0001" min="0" value="<?php echo isset($_POST['final_volume']) ? htmlspecialchars($_POST['final_volume']) : ''; ?>" required>
                                <span class="calc-input">liters</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['initial_volume']) && 
                        isset($_POST['final_volume'])) {
                        
                        // Get input values
                        $initial_volume = floatval($_POST['initial_volume']);
                        $final_volume = floatval($_POST['final_volume']);

                        if ($initial_volume > 0 && $final_volume >= 0 && $final_volume <= $initial_volume) {
                            // Calculate water proof percentage
                            $proof = (($initial_volume - $final_volume) / $initial_volume) * 100;
                            $proof = round($proof, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Proof Percentage:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($proof) ? htmlspecialchars($proof) . " %" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Water Proof Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Proof Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Water Proof Calculation?</h3>
                <p>
Water proof calculation measures the percentage of water resistance or waterproofing effectiveness by comparing initial and final volumes. This calculation is commonly used in various industries to assess material performance and waterproofing capabilities.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water proof formula:
                </p>
                <div class="formula-2-container">
                    \[ \text{Proof (\%)} = \frac{\text{Initial Volume (l)} - \text{Final Volume (l)}}{\text{Initial Volume (l)}} \times 100 \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( \text{Initial Volume} \) — Starting volume measurement in liters</li>
                        <li>\( \text{Final Volume} \) — Remaining volume after testing in liters</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula calculates the percentage of volume change, indicating the effectiveness of waterproofing or water resistance.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Proof Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water proof percentage calculation is crucial for quality control in manufacturing, material testing, construction industry, and product development where water resistance is a critical factor.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter initial volume and final volume in liters. Both values must be valid (initial volume > 0, final volume between 0 and initial volume).
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What does 100% proof mean?</strong><br>
                    A: 100% proof indicates complete water resistance with no volume change, meaning no water penetration or absorption occurred.
                </p>
                <p>
                    <strong>Q2: What is considered good water proof percentage?</strong><br>
                    A: Good water proof percentages typically range from 95-100%, depending on the application and industry standards.
                </p>
                <p>
                    <strong>Q3: When should this calculation be performed?</strong><br>
                    A: This calculation should be performed during material testing, quality assurance checks, and product development phases.
                </p>
                <p>
                    <strong>Q4: Are there limitations to this calculation?</strong><br>
                    A: This calculation assumes linear relationships and may not account for all environmental factors or long-term degradation effects.
                </p>
                <p>
                    <strong>Q5: Can this be used for all materials?</strong><br>
                    A: While applicable to many materials, specific industry standards may require additional tests for comprehensive water resistance evaluation.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Proof Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>