
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Storage Tank Size Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Storage Tank Size Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Storage Tank Size Formula:
                </p>
<div class="formula-container">
    \[ size = daily\_demand \times storage\_days \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="daily_demand" class="label-box">Daily Demand:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="daily_demand" name="daily_demand" step="0.0001" min="0" value="<?php echo isset($_POST['daily_demand']) ? htmlspecialchars($_POST['daily_demand']) : ''; ?>" required>
                                <span class="calc-input">L/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="storage_days" class="label-box">Storage Days:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="storage_days" name="storage_days" min="0" value="<?php echo isset($_POST['storage_days']) ? htmlspecialchars($_POST['storage_days']) : ''; ?>" required>
                                <span class="calc-input">days</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['daily_demand']) && 
                        isset($_POST['storage_days'])) {
                        
                        // Get input values
                        $daily_demand = floatval($_POST['daily_demand']);
                        $storage_days = floatval($_POST['storage_days']);

                        if ($daily_demand > 0 && $storage_days > 0) {
                            // Calculate water storage tank size
                            $size = $daily_demand * $storage_days;
                            $size = round($size, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Storage Tank Size:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($size) ? htmlspecialchars($size) . " L" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What Is Water Storage Tank Size Calculation?</a></li>
                    <li><a href="#section2">2. How Does The Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance Of Water Storage Tank Sizing</a></li>
                    <li><a href="#section4">4. Using The Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What Is Water Storage Tank Size Calculation?</h3>
                <p>
Water storage tank size calculation determines the required capacity of a water storage tank based on daily water demand and the number of days the supply needs to be stored. This ensures adequate water availability during periods of low supply or high demand.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does The Calculator Work?</h3>
                <p>
                    The calculator uses the simple formula:
                </p>
                <div class="formula-2-container">
                    \[ size = daily\_demand \times storage\_days \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( daily\_demand \) — Daily water consumption in liters per day (L/day)</li>
                        <li>\( storage\_days \) — Number of days water needs to be stored</li>
                        <li>\( size \) — Required tank capacity in liters (L)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The calculation multiplies the daily water requirement by the number of storage days needed to determine the total storage capacity required.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance Of Water Storage Tank Sizing</h3>
                <p>
                    <strong>Details:</strong> Proper tank sizing is crucial for ensuring reliable water supply, preventing shortages during dry periods, optimizing storage costs, and maintaining water quality through appropriate turnover rates.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using The Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter daily water demand in liters per day and the number of storage days required. Both values must be positive numbers greater than zero for accurate calculation.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What factors should be considered besides daily demand?</strong><br>
                    A: Consider peak usage periods, safety margins for unexpected demand increases, evaporation losses, and future expansion needs.
                </p>
                <p>
                    <strong>Q2: How does climate affect water storage tank sizing?</strong><br>
                    A: In areas with seasonal rainfall variations, larger storage capacity may be needed to cover extended dry periods.
                </p>
                <p>
                    <strong>Q3: What's the typical range for storage days?</strong><br>
                    A: Storage periods typically range from 1-7 days for municipal systems, but may extend to 30+ days for remote or drought-prone areas.
                </p>
                <p>
                    <strong>Q4: Should I include fire storage requirements?</strong><br>
                    A: For commercial and industrial applications, fire storage requirements must be added to the domestic water storage calculation.
                </p>
                <p>
                    <strong>Q5: How does tank shape affect capacity calculations?</strong><br>
                    A: While capacity is measured in volume, tank shape affects available space and may require adjustments for practical installation.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Storage Tank Size Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>