
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Stress Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Stress Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Stress Formula:
                </p>
<div class="formula-container">
    \[ Stress = \frac{Withdrawal}{Availability} \times 100 \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="withdrawal" class="label-box">Withdrawal:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="withdrawal" name="withdrawal" step="0.0001" min="0" value="<?php echo isset($_POST['withdrawal']) ? htmlspecialchars($_POST['withdrawal']) : ''; ?>" required>
                                <span class="calc-input">m³</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="availability" class="label-box">Availability:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="availability" name="availability" step="0.0001" min="0" value="<?php echo isset($_POST['availability']) ? htmlspecialchars($_POST['availability']) : ''; ?>" required>
                                <span class="calc-input">m³</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['withdrawal']) && 
                        isset($_POST['availability'])) {
                        
                        // Get input values
                        $withdrawal = floatval($_POST['withdrawal']);
                        $availability = floatval($_POST['availability']);

                        if ($withdrawal > 0 && $availability > 0) {
                            // Calculate water stress percentage
                            $stress = ($withdrawal / $availability) * 100;
                            $stress = round($stress, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Stress:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($stress) ? htmlspecialchars($stress) . " %" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Water Stress Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Stress Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Water Stress Calculation?</h3>
                <p>
Water stress calculation measures the percentage of total available water resources that is being withdrawn for human use. It's a key indicator of water scarcity and sustainability in a region.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water stress formula:
                </p>
                <div class="formula-2-container">
                    \[ Stress = \frac{Withdrawal}{Availability} \times 100 \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Withdrawal \) — Total water withdrawal (m³)</li>
                        <li>\( Availability \) — Total available water resources (m³)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates the percentage of available water that is being consumed, indicating the level of water stress in a given area.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Stress Calculation</h3>
                <p>
                    <strong>Details:</strong> Water stress assessment is crucial for sustainable water resource management, identifying regions at risk of water scarcity, and planning for future water needs and conservation strategies.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter water withdrawal and availability values in cubic meters (m³). Both values must be positive numbers greater than zero for accurate calculation.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What constitutes high water stress?</strong><br>
                    A: Generally, water stress above 40% is considered high, indicating significant pressure on water resources and potential scarcity issues.
                </p>
                <p>
                    <strong>Q2: How is water availability measured?</strong><br>
                    A: Water availability typically includes surface water (rivers, lakes) and renewable groundwater resources available for use in a given time period.
                </p>
                <p>
                    <strong>Q3: What factors contribute to water withdrawal?</strong><br>
                    A: Water withdrawal includes agricultural irrigation, industrial use, municipal water supply, and other human consumption activities.
                </p>
                <p>
                    <strong>Q4: Are there seasonal variations in water stress?</strong><br>
                    A: Yes, water stress can vary seasonally due to rainfall patterns, snowmelt, and changing water demand throughout the year.
                </p>
                <p>
                    <strong>Q5: How can water stress be reduced?</strong><br>
                    A: Strategies include water conservation, improved irrigation efficiency, wastewater recycling, and better water resource management practices.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Stress Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
