
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Supply Calculation Examples</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Supply Calculation Examples</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Supply Equation:
                </p>
<div class="formula-container">
    \[ \text{Supply} = \text{Demand} + \text{Losses\_Supply} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="demand" class="label-box">Demand:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="demand" name="demand" step="0.0001" min="0" value="<?php echo isset($_POST['demand']) ? htmlspecialchars($_POST['demand']) : ''; ?>" required>
                                <span class="calc-input">L/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="losses_supply" class="label-box">Losses Supply:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="losses_supply" name="losses_supply" step="0.0001" min="0" value="<?php echo isset($_POST['losses_supply']) ? htmlspecialchars($_POST['losses_supply']) : ''; ?>" required>
                                <span class="calc-input">L/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['demand']) && 
                        isset($_POST['losses_supply'])) {
                        
                        // Get input values
                        $demand = floatval($_POST['demand']);
                        $losses_supply = floatval($_POST['losses_supply']);

                        if ($demand >= 0 && $losses_supply >= 0) {
                            // Calculate water supply
                            $supply = $demand + $losses_supply;
                            $supply = round($supply, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Supply:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($supply) ? htmlspecialchars($supply) . " L/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What Is Water Supply Calculation?</a></li>
                    <li><a href="#section2">2. How Does The Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance Of Water Supply Calculation</a></li>
                    <li><a href="#section4">4. Using The Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What Is Water Supply Calculation?</h3>
                <p>
Water supply calculation determines the total water required by adding the demand (actual water usage) and supply losses (water lost during distribution). This is essential for proper water resource management and infrastructure planning.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does The Calculator Work?</h3>
                <p>
                    The calculator uses the water supply equation:
                </p>
                <div class="formula-2-container">
                    \[ \text{Supply} = \text{Demand} + \text{Losses\_Supply} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( \text{Demand} \) — Actual water consumption (L/day)</li>
                        <li>\( \text{Losses\_Supply} \) — Water losses in the supply system (L/day)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> This equation accounts for both the water that reaches consumers and the water lost through leaks, evaporation, or other distribution inefficiencies.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance Of Water Supply Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water supply calculation is crucial for sustainable water management, infrastructure design, conservation planning, and ensuring adequate water availability for communities and industries.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using The Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter water demand and supply losses in liters per day (L/day). Both values must be non-negative numbers. The calculator will compute the total water supply required.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What constitutes typical water demand values?</strong><br>
                    A: Water demand varies by region and usage but typically ranges from 100-300 L/day per person for domestic use, plus industrial and agricultural requirements.
                </p>
                <p>
                    <strong>Q2: What are common causes of supply losses?</strong><br>
                    A: Supply losses typically include leakage from pipes, evaporation from open reservoirs, unauthorized connections, and meter inaccuracies.
                </p>
                <p>
                    <strong>Q3: How can supply losses be minimized?</strong><br>
                    A: Regular maintenance, pipe replacement programs, pressure management, and leak detection systems can significantly reduce supply losses.
                </p>
                <p>
                    <strong>Q4: Are there industry standards for acceptable loss percentages?</strong><br>
                    A: Many water authorities aim for less than 10-15% losses, though actual percentages vary widely between systems from 5% to over 50% in some aging infrastructures.
                </p>
                <p>
                    <strong>Q5: How does this calculation help in water conservation?</strong><br>
                    A: By quantifying both demand and losses, utilities can identify areas for improvement, prioritize infrastructure investments, and develop more effective water conservation strategies.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Supply Calculation Examples© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>