
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Tank Head Pressure Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Tank Head Pressure Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Head Pressure Formula:
                </p>
<div class="formula-container">
    \[ P = \rho \times g \times h \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="h" class="label-box">Height (h):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="h" name="h" step="0.0001" min="0" value="<?php echo isset($_POST['h']) ? htmlspecialchars($_POST['h']) : ''; ?>" required>
                                <span class="calc-input">m</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="density" class="label-box">Density (ρ):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="density" name="density" step="0.0001" min="0" value="<?php echo isset($_POST['density']) ? htmlspecialchars($_POST['density']) : '1000'; ?>" required>
                                <span class="calc-input">kg/m³</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="gravity" class="label-box">Gravity (g):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="gravity" name="gravity" step="0.0001" min="0" value="<?php echo isset($_POST['gravity']) ? htmlspecialchars($_POST['gravity']) : '9.81'; ?>" required>
                                <span class="calc-input">m/s²</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['h']) && 
                        isset($_POST['density']) &&
                        isset($_POST['gravity'])) {
                        
                        // Get input values
                        $h = floatval($_POST['h']);
                        $density = floatval($_POST['density']);
                        $gravity = floatval($_POST['gravity']);

                        if ($h > 0 && $density > 0 && $gravity > 0) {
                            // Calculate head pressure
                            $pressure = $density * $gravity * $h;
                            $pressure = round($pressure, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Head Pressure (P):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($pressure) ? htmlspecialchars($pressure) . " Pa" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Water Tank Head Pressure?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Head Pressure Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Water Tank Head Pressure?</h3>
                <p>
Water tank head pressure refers to the pressure exerted by a column of water at the bottom of a tank due to the weight of the water above it. This pressure is crucial for designing water supply systems and ensuring adequate water flow.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the head pressure formula:
                </p>
                <div class="formula-2-container">
                    \[ P = \rho \times g \times h \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( P \) — Head pressure (Pascals)</li>
                        <li>\( \rho \) — Fluid density (kg/m³)</li>
                        <li>\( g \) — Gravitational acceleration (m/s²)</li>
                        <li>\( h \) — Height of water column (m)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula calculates the hydrostatic pressure at the bottom of a water column based on the density of the fluid, gravitational force, and the height of the column.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Head Pressure Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate head pressure calculation is essential for designing water storage tanks, irrigation systems, and plumbing systems to ensure proper water flow and pressure distribution.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the height of water column in meters, fluid density in kg/m³ (default 1000 for water), and gravitational acceleration in m/s² (default 9.81). All values must be positive.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is the standard density value for water?</strong><br>
                    A: The standard density of water is 1000 kg/m³ at 4°C. Density may vary slightly with temperature.
                </p>
                <p>
                    <strong>Q2: Why is gravitational acceleration important?</strong><br>
                    A: Gravitational acceleration determines the weight of the water column, which directly affects the pressure at the bottom.
                </p>
                <p>
                    <strong>Q3: How does head pressure affect water flow?</strong><br>
                    A: Higher head pressure results in greater water flow velocity and volume through pipes and outlets.
                </p>
                <p>
                    <strong>Q4: Can this calculator be used for other fluids?</strong><br>
                    A: Yes, simply input the appropriate density value for the specific fluid you are working with.
                </p>
                <p>
                    <strong>Q5: What units are used for pressure measurement?</strong><br>
                    A: Pressure is measured in Pascals (Pa) in this calculator. 1 Pascal = 1 Newton per square meter.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Tank Head Pressure Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>