
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Tank Size Calculation</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Tank Size Calculation</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Tank Size Formula:
                </p>
<div class="formula-container">
    \[ Size = Demand \times Days \times Factor \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="demand" class="label-box">Demand (L/day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="demand" name="demand" step="0.0001" min="0" value="<?php echo isset($_POST['demand']) ? htmlspecialchars($_POST['demand']) : ''; ?>" required>
                                <span class="calc-input">L/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="days" class="label-box">Days:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="days" name="days" min="0" value="<?php echo isset($_POST['days']) ? htmlspecialchars($_POST['days']) : ''; ?>" required>
                                <span class="calc-input">days</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="factor" class="label-box">Factor (dimensionless):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="factor" name="factor" step="0.0001" min="0" value="<?php echo isset($_POST['factor']) ? htmlspecialchars($_POST['factor']) : ''; ?>" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['demand']) && 
                        isset($_POST['days']) &&
                        isset($_POST['factor'])) {
                        
                        // Get input values
                        $demand = floatval($_POST['demand']);
                        $days = floatval($_POST['days']);
                        $factor = floatval($_POST['factor']);

                        if ($demand > 0 && $days > 0 && $factor > 0) {
                            // Calculate water tank size
                            $size = $demand * $days * $factor;
                            $size = round($size, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Size (L):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($size) ? htmlspecialchars($size) . " L" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Water Tank Size Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Tank Sizing</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Water Tank Size Calculation?</h3>
                <p>
Water tank size calculation determines the appropriate storage capacity needed to meet water demand over a specified period, accounting for safety factors and usage patterns.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water tank size formula:
                </p>
                <div class="formula-2-container">
                    \[ Size = Demand \times Days \times Factor \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Size \) — Water tank capacity (L)</li>
                        <li>\( Demand \) — Daily water consumption (L/day)</li>
                        <li>\( Days \) — Storage period (days)</li>
                        <li>\( Factor \) — Safety factor (dimensionless)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The formula calculates the minimum tank capacity required to store water for the specified number of days, multiplied by a safety factor to account for variations in usage and supply.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Tank Sizing</h3>
                <p>
                    <strong>Details:</strong> Proper water tank sizing ensures adequate water supply during periods of low rainfall, water shortages, or emergency situations while avoiding over-sizing that leads to unnecessary costs.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter daily water demand in liters per day, storage period in days, and safety factor (typically 1.1-1.5). All values must be positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is a typical safety factor value?</strong><br>
                    A: Safety factors typically range from 1.1 to 1.5, depending on usage variability, climate conditions, and reliability of water supply.
                </p>
                <p>
                    <strong>Q2: How do I determine daily water demand?</strong><br>
                    A: Daily demand can be estimated based on number of users, typical consumption patterns, or historical usage data. Residential use is typically 100-200 L per person per day.
                </p>
                <p>
                    <strong>Q3: What storage period should I use?</strong><br>
                    A: Storage period depends on local rainfall patterns, water supply reliability, and intended use. Typical periods range from 3-10 days for residential use.
                </p>
                <p>
                    <strong>Q4: Does this account for evaporation losses?</strong><br>
                    A: The basic formula doesn't account for evaporation. In hot climates, consider increasing the safety factor or adding an evaporation allowance.
                </p>
                <p>
                    <strong>Q5: Can this be used for commercial applications?</strong><br>
                    A: Yes, the same formula applies, but commercial demands and safety factors may differ significantly from residential applications.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Tank Size Calculation© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
