
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Tank Size Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Tank Size Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Tank Size Formula:
                </p>
<div class="formula-container">
    \[ \text{size} = \text{daily\_usage} \times \text{days\_storage} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="daily_usage" class="label-box">Daily Usage:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="daily_usage" name="daily_usage" step="0.01" min="0" value="<?php echo isset($_POST['daily_usage']) ? htmlspecialchars($_POST['daily_usage']) : ''; ?>" required>
                                <span class="calc-input">L/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="days_storage" class="label-box">Days Storage:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="days_storage" name="days_storage" min="1" value="<?php echo isset($_POST['days_storage']) ? htmlspecialchars($_POST['days_storage']) : ''; ?>" required>
                                <span class="calc-input">days</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['daily_usage']) && 
                        isset($_POST['days_storage'])) {
                        
                        // Get input values
                        $daily_usage = floatval($_POST['daily_usage']);
                        $days_storage = intval($_POST['days_storage']);

                        if ($daily_usage > 0 && $days_storage > 0) {
                            // Calculate tank size
                            $size = $daily_usage * $days_storage;
                            $size = round($size, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Tank Size Required:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($size) ? htmlspecialchars($size) . " L" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Water Tank Size Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Proper Tank Sizing</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Water Tank Size Calculation?</h3>
                <p>
Water tank size calculation determines the appropriate storage capacity needed based on daily water consumption and desired storage duration. This ensures adequate water supply for residential, commercial, or agricultural needs.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the simple formula:
                </p>
                <div class="formula-2-container">
                    \[ \text{size} = \text{daily\_usage} \times \text{days\_storage} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( \text{daily\_usage} \) — Daily water consumption in liters per day</li>
                        <li>\( \text{days\_storage} \) — Number of days water needs to be stored</li>
                        <li>\( \text{size} \) — Required tank capacity in liters</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> This formula calculates the total volume needed by multiplying daily consumption by the number of storage days required.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Proper Tank Sizing</h3>
                <p>
                    <strong>Details:</strong> Proper tank sizing is crucial for ensuring adequate water supply, preventing shortages, optimizing storage costs, and maintaining water quality through appropriate turnover rates.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter daily water usage in liters per day and desired storage duration in days. Both values must be positive numbers for accurate calculation.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Should I add a safety margin to the calculated size?</strong><br>
                    A: Yes, it's recommended to add 10-20% safety margin to account for unexpected usage increases or emergency situations.
                </p>
                <p>
                    <strong>Q2: How do I estimate daily water usage?</strong><br>
                    A: Track water meter readings over several days or use average consumption rates (e.g., 150-200L per person per day for residential use).
                </p>
                <p>
                    <strong>Q3: Does this calculation consider rainfall collection?</strong><br>
                    A: No, this is a basic calculation for storage needs. Rainwater harvesting systems require additional considerations for collection area and rainfall patterns.
                </p>
                <p>
                    <strong>Q4: What about evaporation losses?</strong><br>
                    A: For outdoor storage in hot climates, consider adding 5-10% extra capacity to account for evaporation losses.
                </p>
                <p>
                    <strong>Q5: How often should tanks be cleaned?</strong><br>
                    A: Tanks should be inspected and cleaned annually, or more frequently if water quality issues are noticed.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Tank Size Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>