
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Tower Capacity Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Tower Capacity Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Tower Capacity Equation:
                </p>
<div class="formula-container">
    \[ Capacity = Population \times Per\ Capita\ Demand \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="population" class="label-box">Population:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="population" name="population" min="0" value="<?php echo isset($_POST['population']) ? htmlspecialchars($_POST['population']) : ''; ?>" required>
                                <span class="calc-input">people</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="per_capita_demand" class="label-box">Per Capita Demand:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="per_capita_demand" name="per_capita_demand" step="0.0001" min="0" value="<?php echo isset($_POST['per_capita_demand']) ? htmlspecialchars($_POST['per_capita_demand']) : ''; ?>" required>
                                <span class="calc-input">L/person</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['population']) && 
                        isset($_POST['per_capita_demand'])) {
                        
                        // Get input values
                        $population = floatval($_POST['population']);
                        $per_capita_demand = floatval($_POST['per_capita_demand']);

                        if ($population > 0 && $per_capita_demand > 0) {
                            // Calculate water tower capacity
                            $capacity = $population * $per_capita_demand;
                            $capacity = round($capacity, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Tower Capacity:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($capacity) ? htmlspecialchars($capacity) . " L" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Water Tower Capacity Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Tower Capacity Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Water Tower Capacity Calculation?</h3>
                <p>
Water tower capacity calculation determines the required storage volume for a water tower based on population served and per capita water demand. This ensures adequate water supply during peak demand periods and emergency situations.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water tower capacity equation:
                </p>
                <div class="formula-2-container">
                    \[ Capacity = Population \times Per\ Capita\ Demand \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Population \) — Number of people served by the water tower</li>
                        <li>\( Per\ Capita\ Demand \) — Water demand per person (L/person)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates the total water storage capacity needed to serve a specific population based on their water consumption patterns.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Tower Capacity Calculation</h3>
                <p>
                    <strong>Details:</strong> Proper water tower sizing is essential for municipal water supply systems to maintain consistent water pressure, handle peak demand periods, and provide emergency storage for firefighting and system outages.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter population count and per capita water demand in liters per person. Both values must be positive numbers for accurate calculation.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What factors affect per capita water demand?</strong><br>
                    A: Climate, household appliances, industrial usage, conservation practices, and time of year all influence water consumption patterns.
                </p>
                <p>
                    <strong>Q2: How is emergency storage accounted for?</strong><br>
                    A: Most municipal codes require additional capacity beyond daily demand for fire protection and emergency situations.
                </p>
                <p>
                    <strong>Q3: What is a typical per capita water demand?</strong><br>
                    A: Residential water use typically ranges from 150-300 L/person/day, but varies significantly by region and community characteristics.
                </p>
                <p>
                    <strong>Q4: Should peak demand factors be considered?</strong><br>
                    A: Yes, water towers are typically sized to handle peak demand periods, which can be 2-3 times average daily consumption.
                </p>
                <p>
                    <strong>Q5: How often should water tower capacity be reevaluated?</strong><br>
                    A: Capacity should be reassessed whenever population changes significantly or when water consumption patterns shift due to new development or conservation programs.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Tower Capacity Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
