
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Usage Calculator For Schools</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Usage Calculator For Schools</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Usage Equation:
                </p>
<div class="formula-container">
    \[ Usage = Students \times School\ Rate \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="students" class="label-box">Students:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="students" name="students" min="0" value="<?php echo isset($_POST['students']) ? htmlspecialchars($_POST['students']) : ''; ?>" required>
                                <span class="calc-input">number</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="school_rate" class="label-box">School Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="school_rate" name="school_rate" step="0.0001" min="0" value="<?php echo isset($_POST['school_rate']) ? htmlspecialchars($_POST['school_rate']) : ''; ?>" required>
                                <span class="calc-input">L/student/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['students']) && 
                        isset($_POST['school_rate'])) {
                        
                        // Get input values
                        $students = intval($_POST['students']);
                        $school_rate = floatval($_POST['school_rate']);

                        if ($students > 0 && $school_rate > 0) {
                            // Calculate water usage
                            $usage = $students * $school_rate;
                            $usage = round($usage, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Usage:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($usage) ? htmlspecialchars($usage) . " L/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Water Usage Calculator For Schools?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Usage Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Water Usage Calculator For Schools?</h3>
                <p>
The Water Usage Calculator For Schools estimates daily water consumption based on the number of students and the water usage rate per student. It helps schools plan and manage their water resources efficiently.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water usage equation:
                </p>
                <div class="formula-2-container">
                    \[ Usage = Students \times School\ Rate \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Students \) — Number of students</li>
                        <li>\( School\ Rate \) — Water usage rate per student (L/student/day)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates total daily water usage by multiplying the number of students by the average water consumption per student.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Usage Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water usage estimation is crucial for sustainable water management, infrastructure planning, and environmental conservation in educational institutions.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the number of students and the water usage rate per student in L/student/day. Both values must be valid positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is a typical school water usage rate?</strong><br>
                    A: Typical rates range from 20-50 L/student/day depending on facilities, climate, and conservation measures.
                </p>
                <p>
                    <strong>Q2: Why calculate water usage for schools?</strong><br>
                    A: It helps in budgeting, infrastructure planning, identifying conservation opportunities, and ensuring sustainable water management.
                </p>
                <p>
                    <strong>Q3: Should seasonal variations be considered?</strong><br>
                    A: Yes, water usage may vary by season due to climate conditions, school activities, and operational changes.
                </p>
                <p>
                    <strong>Q4: Are there ways to reduce school water usage?</strong><br>
                    A: Yes, through water-efficient fixtures, rainwater harvesting, leak detection, and water conservation education programs.
                </p>
                <p>
                    <strong>Q5: How often should water usage be calculated?</strong><br>
                    A: Regular monitoring (monthly or quarterly) is recommended to track usage patterns and identify opportunities for improvement.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Usage Calculator For Schools© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>