
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Usage Calculator For Students</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Usage Calculator For Students</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Usage Equation:
                </p>
<div class="formula-container">
    \[ usage = student\_activities \times student\_rate \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="student_activities" class="label-box">Student Activities:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="student_activities" name="student_activities" step="0.0001" min="0" value="<?php echo isset($_POST['student_activities']) ? htmlspecialchars($_POST['student_activities']) : ''; ?>" required>
                                <span class="calc-input">activities/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="student_rate" class="label-box">Student Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="student_rate" name="student_rate" step="0.0001" min="0" value="<?php echo isset($_POST['student_rate']) ? htmlspecialchars($_POST['student_rate']) : ''; ?>" required>
                                <span class="calc-input">L/activity</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['student_activities']) && 
                        isset($_POST['student_rate'])) {
                        
                        // Get input values
                        $student_activities = floatval($_POST['student_activities']);
                        $student_rate = floatval($_POST['student_rate']);

                        if ($student_activities > 0 && $student_rate > 0) {
                            // Calculate water usage
                            $usage = $student_activities * $student_rate;
                            $usage = round($usage, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Usage:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($usage) ? htmlspecialchars($usage) . " L/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Water Usage Calculator For Students?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Usage Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Water Usage Calculator For Students?</h3>
                <p>
The Water Usage Calculator For Students estimates daily water consumption based on student activities and water usage rate per activity. It provides an accurate assessment of water requirements for educational institutions.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water usage equation:
                </p>
                <div class="formula-2-container">
                    \[ usage = student\_activities \times student\_rate \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( student\_activities \) — Number of activities per day</li>
                        <li>\( student\_rate \) — Water consumption rate per activity (L/activity)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates total daily water usage by multiplying the number of student activities by the water consumption rate per activity.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Usage Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water usage estimation is crucial for resource planning, sustainability initiatives, and cost management in educational facilities.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter student activities (number per day) and student rate (liters per activity). All values must be valid positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What types of activities should be included?</strong><br>
                    A: Include all water-consuming activities such as hand washing, drinking, laboratory work, and cleaning activities.
                </p>
                <p>
                    <strong>Q2: How accurate is this calculation?</strong><br>
                    A: Accuracy depends on precise measurement of activities and consumption rates. Regular monitoring improves reliability.
                </p>
                <p>
                    <strong>Q3: Can this be used for large institutions?</strong><br>
                    A: Yes, the calculation can be scaled for any size institution by adjusting the activity counts accordingly.
                </p>
                <p>
                    <strong>Q4: How often should calculations be updated?</strong><br>
                    A: Regular updates are recommended, especially when there are changes in student population or water usage patterns.
                </p>
                <p>
                    <strong>Q5: What factors can affect water usage rates?</strong><br>
                    A: Factors include efficiency of fixtures, student behavior, seasonal variations, and conservation measures implemented.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Usage Calculator For Students© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>