
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Usage Calculator South Australia</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Usage Calculator South Australia</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Usage Formula:
                </p>
<div class="formula-container">
    \[ Usage = \sum(DailyUses \times SouthAusRates) \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="daily_uses" class="label-box">Daily Uses (uses/day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="daily_uses" name="daily_uses" step="0.01" min="0" value="<?php echo isset($_POST['daily_uses']) ? htmlspecialchars($_POST['daily_uses']) : ''; ?>" required>
                                <span class="calc-input">uses/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="south_aus_rates" class="label-box">South Australia Rates (L/use):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="south_aus_rates" name="south_aus_rates" step="0.01" min="0" value="<?php echo isset($_POST['south_aus_rates']) ? htmlspecialchars($_POST['south_aus_rates']) : ''; ?>" required>
                                <span class="calc-input">L/use</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['daily_uses']) && 
                        isset($_POST['south_aus_rates'])) {
                        
                        // Get input values
                        $daily_uses = floatval($_POST['daily_uses']);
                        $south_aus_rates = floatval($_POST['south_aus_rates']);

                        if ($daily_uses > 0 && $south_aus_rates > 0) {
                            // Calculate water usage
                            $usage = $daily_uses * $south_aus_rates;
                            $usage = round($usage, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Usage (L/day):</label>
                        <input class="calc-input" type="text" value='<?php echo isset($usage) ? htmlspecialchars($usage) . " L/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Water Usage Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Usage Monitoring</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Water Usage Calculation?</h3>
                <p>
Water usage calculation helps estimate daily water consumption based on usage frequency and South Australian water rates. It provides valuable insights for water conservation and management.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water usage formula:
                </p>
                <div class="formula-2-container">
                    \[ Usage = \sum(DailyUses \times SouthAusRates) \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( DailyUses \) — Number of uses per day</li>
                        <li>\( SouthAusRates \) — Water consumption rate per use in liters (South Australian standards)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation multiplies the daily frequency of water usage by the standard water consumption rate per use to estimate total daily water usage.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Usage Monitoring</h3>
                <p>
                    <strong>Details:</strong> Monitoring water usage is crucial for sustainable water management, conservation efforts, and understanding personal or household water consumption patterns in South Australia.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the number of daily uses and the South Australian water rate per use in liters. All values must be valid positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What are typical South Australian water rates?</strong><br>
                    A: Water rates vary by activity but typically range from 6-15 liters per use for various household activities.
                </p>
                <p>
                    <strong>Q2: Why calculate water usage?</strong><br>
                    A: Calculating water usage helps in conservation efforts, bill estimation, and sustainable water management practices.
                </p>
                <p>
                    <strong>Q3: How accurate is this calculation?</strong><br>
                    A: The accuracy depends on the precision of your usage estimates and the standard rates used. It provides a good estimate for planning purposes.
                </p>
                <p>
                    <strong>Q4: Can this be used for commercial purposes?</strong><br>
                    A: While the basic formula applies, commercial water usage may require more complex calculations accounting for multiple usage types.
                </p>
                <p>
                    <strong>Q5: Where can I find official South Australian water rates?</strong><br>
                    A: Official water rates can be found on the South Australian Water Corporation website or through local water authority publications.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Usage Calculator South Australia© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
