
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Usage Calculator UK Gov</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Usage Calculator UK Gov</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    UK Government Water Usage Formula:
                </p>
<div class="formula-container">
    \[ Usage = \sum(DailyUses \times UKGovFlowRates) \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="shower_uses" class="label-box">Shower Uses (per day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="shower_uses" name="shower_uses" min="0" value="<?php echo isset($_POST['shower_uses']) ? htmlspecialchars($_POST['shower_uses']) : '0'; ?>" required>
                                <span class="calc-input">uses/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="toilet_uses" class="label-box">Toilet Flushes (per day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="toilet_uses" name="toilet_uses" min="0" value="<?php echo isset($_POST['toilet_uses']) ? htmlspecialchars($_POST['toilet_uses']) : '0'; ?>" required>
                                <span class="calc-input">uses/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="faucet_uses" class="label-box">Faucet Uses (per day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="faucet_uses" name="faucet_uses" min="0" value="<?php echo isset($_POST['faucet_uses']) ? htmlspecialchars($_POST['faucet_uses']) : '0'; ?>" required>
                                <span class="calc-input">uses/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="dishwasher_uses" class="label-box">Dishwasher Uses (per day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="dishwasher_uses" name="dishwasher_uses" min="0" value="<?php echo isset($_POST['dishwasher_uses']) ? htmlspecialchars($_POST['dishwasher_uses']) : '0'; ?>" required>
                                <span class="calc-input">uses/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="washing_machine_uses" class="label-box">Washing Machine Uses (per day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="washing_machine_uses" name="washing_machine_uses" min="0" value="<?php echo isset($_POST['washing_machine_uses']) ? htmlspecialchars($_POST['washing_machine_uses']) : '0'; ?>" required>
                                <span class="calc-input">uses/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST") {
                        // UK Government standard flow rates (L/use)
                        $flow_rates = [
                            'shower' => 62,        // Average shower use
                            'toilet' => 9,         // Dual flush toilet average
                            'faucet' => 8,         // Per minute of use (estimated 1 min/use)
                            'dishwasher' => 15,    // Per cycle
                            'washing_machine' => 50 // Per cycle
                        ];
                        
                        // Get input values
                        $shower_uses = isset($_POST['shower_uses']) ? intval($_POST['shower_uses']) : 0;
                        $toilet_uses = isset($_POST['toilet_uses']) ? intval($_POST['toilet_uses']) : 0;
                        $faucet_uses = isset($_POST['faucet_uses']) ? intval($_POST['faucet_uses']) : 0;
                        $dishwasher_uses = isset($_POST['dishwasher_uses']) ? intval($_POST['dishwasher_uses']) : 0;
                        $washing_machine_uses = isset($_POST['washing_machine_uses']) ? intval($_POST['washing_machine_uses']) : 0;
                        
                        // Calculate total water usage
                        $total_usage = ($shower_uses * $flow_rates['shower']) +
                                      ($toilet_uses * $flow_rates['toilet']) +
                                      ($faucet_uses * $flow_rates['faucet']) +
                                      ($dishwasher_uses * $flow_rates['dishwasher']) +
                                      ($washing_machine_uses * $flow_rates['washing_machine']);
                    }
                    ?>

                    <div class="result-box">
                        <label>Estimated Daily Water Usage:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($total_usage) ? htmlspecialchars($total_usage) . " L/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What Is The UK Government Water Usage Calculation?</a></li>
                    <li><a href="#section2">2. How Does The Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance Of Water Usage Monitoring</a></li>
                    <li><a href="#section4">4. Using The Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What Is The UK Government Water Usage Calculation?</h3>
                <p>
The UK Government water usage calculation estimates daily water consumption based on standard flow rates for common household activities. This helps individuals and households understand their water footprint and identify opportunities for conservation.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does The Calculator Work?</h3>
                <p>
                    The calculator uses the UK Government standard formula:
                </p>
                <div class="formula-2-container">
                    \[ Usage = \sum(DailyUses \times UKGovFlowRates) \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( DailyUses \) — Number of times each fixture is used per day</li>
                        <li>\( UKGovFlowRates \) — Standard water consumption rates (L/use)</li>
                    </ul>
                </p>
                <p>
                    <strong>Standard Flow Rates:</strong>
                    <ul>
                        <li>Shower: 62 L/use</li>
                        <li>Toilet: 9 L/use</li>
                        <li>Faucet: 8 L/use (estimated 1 minute per use)</li>
                        <li>Dishwasher: 15 L/cycle</li>
                        <li>Washing Machine: 50 L/cycle</li>
                    </ul>
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance Of Water Usage Monitoring</h3>
                <p>
                    <strong>Details:</strong> Monitoring water usage is essential for conservation efforts, reducing environmental impact, and lowering utility bills. The UK Government encourages water efficiency to ensure sustainable water resources for future generations.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using The Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the number of times you use each water fixture daily. The calculator will estimate your total water consumption based on UK Government standard flow rates. All values should be zero or positive integers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Are these flow rates accurate for all households?</strong><br>
                    A: These are standard averages. Actual consumption may vary based on specific appliance models, water pressure, and usage habits.
                </p>
                <p>
                    <strong>Q2: How can I reduce my water usage?</strong><br>
                    A: Install water-efficient fixtures, fix leaks promptly, take shorter showers, and only run full loads in dishwashers and washing machines.
                </p>
                <p>
                    <strong>Q3: What is the average water usage per person in the UK?</strong><br>
                    A: The average person in England uses approximately 142 liters per day, according to recent statistics.
                </p>
                <p>
                    <strong>Q4: Does this calculator include outdoor water usage?</strong><br>
                    A: No, this calculator focuses on indoor household water usage. Gardening, car washing, and other outdoor uses would need to be calculated separately.
                </p>
                <p>
                    <strong>Q5: How often should I monitor my water usage?</strong><br>
                    A: Regular monitoring helps identify trends and potential leaks. Checking monthly is recommended for most households.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Usage Calculator UK Gov© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
