
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Usage Per Day Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Usage Per Day Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Usage Formula:
                </p>
<div class="formula-container">
    \[ Usage = \sum (Daily\ Activities \times Rates) \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="shower" class="label-box">Shower (times/day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="shower" name="shower" step="0.1" min="0" value="<?php echo isset($_POST['shower']) ? htmlspecialchars($_POST['shower']) : '0'; ?>" required>
                                <span class="calc-input">activities/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="shower_rate" class="label-box">Shower Rate (L/activity):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="shower_rate" name="shower_rate" step="0.1" min="0" value="<?php echo isset($_POST['shower_rate']) ? htmlspecialchars($_POST['shower_rate']) : '0'; ?>" required>
                                <span class="calc-input">L/activity</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="dishwashing" class="label-box">Dishwashing (times/day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="dishwashing" name="dishwashing" step="0.1" min="0" value="<?php echo isset($_POST['dishwashing']) ? htmlspecialchars($_POST['dishwashing']) : '0'; ?>" required>
                                <span class="calc-input">activities/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="dishwashing_rate" class="label-box">Dishwashing Rate (L/activity):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="dishwashing_rate" name="dishwashing_rate" step="0.1" min="0" value="<?php echo isset($_POST['dishwashing_rate']) ? htmlspecialchars($_POST['dishwashing_rate']) : '0'; ?>" required>
                                <span class="calc-input">L/activity</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="laundry" class="label-box">Laundry (times/day):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="laundry" name="laundry" step="0.1" min="0" value="<?php echo isset($_POST['laundry']) ? htmlspecialchars($_POST['laundry']) : '0'; ?>" required>
                                <span class="calc-input">activities/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="laundry_rate" class="label-box">Laundry Rate (L/activity):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="laundry_rate" name="laundry_rate" step="0.1" min="0" value="<?php echo isset($_POST['laundry_rate']) ? htmlspecialchars($_POST['laundry_rate']) : '0'; ?>" required>
                                <span class="calc-input">L/activity</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['shower']) && 
                        isset($_POST['shower_rate']) &&
                        isset($_POST['dishwashing']) &&
                        isset($_POST['dishwashing_rate']) &&
                        isset($_POST['laundry']) &&
                        isset($_POST['laundry_rate'])) {
                        
                        // Get input values
                        $shower = floatval($_POST['shower']);
                        $shower_rate = floatval($_POST['shower_rate']);
                        $dishwashing = floatval($_POST['dishwashing']);
                        $dishwashing_rate = floatval($_POST['dishwashing_rate']);
                        $laundry = floatval($_POST['laundry']);
                        $laundry_rate = floatval($_POST['laundry_rate']);

                        if ($shower >= 0 && $shower_rate >= 0 && $dishwashing >= 0 && $dishwashing_rate >= 0 && $laundry >= 0 && $laundry_rate >= 0) {
                            // Calculate water usage
                            $usage = ($shower * $shower_rate) + ($dishwashing * $dishwashing_rate) + ($laundry * $laundry_rate);
                            $usage = round($usage, 1);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Usage Per Day:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($usage) ? htmlspecialchars($usage) . " L/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Water Usage Per Day Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Usage Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Water Usage Per Day Calculation?</h3>
                <p>
Water usage per day calculation estimates the total amount of water consumed daily based on various activities and their respective water consumption rates. This helps in understanding and managing water consumption patterns.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water usage formula:
                </p>
                <div class="formula-2-container">
                    \[ Usage = \sum (Daily\ Activities \times Rates) \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Daily\ Activities \) — Number of times an activity is performed per day</li>
                        <li>\( Rates \) — Water consumption per activity in liters</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates total water usage by summing the products of each activity's frequency and its corresponding water consumption rate.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Usage Calculation</h3>
                <p>
                    <strong>Details:</strong> Calculating daily water usage helps in water conservation efforts, identifying high-consumption activities, and making informed decisions to reduce water waste.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the frequency of each activity per day and the corresponding water consumption rate per activity. All values must be non-negative numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What activities are typically included in water usage calculation?</strong><br>
                    A: Common activities include showering, dishwashing, laundry, toilet flushing, and gardening. The calculator allows customization of activities and rates.
                </p>
                <p>
                    <strong>Q2: How accurate is the water usage calculation?</strong><br>
                    A: Accuracy depends on the precision of the input values. Using measured or estimated rates for each activity improves the reliability of the calculation.
                </p>
                <p>
                    <strong>Q3: Why is it important to calculate water usage?</strong><br>
                    A: It helps in managing water resources efficiently, reducing water bills, and contributing to environmental conservation by identifying areas for reduction.
                </p>
                <p>
                    <strong>Q4: Can I add more activities to the calculation?</strong><br>
                    A: The current calculator includes common activities. For additional activities, you can manually calculate and sum their water usage or modify the calculator code.
                </p>
                <p>
                    <strong>Q5: What are typical water consumption rates for common activities?</strong><br>
                    A: Rates vary: shower (40-60 L), dishwashing by hand (20-30 L), dishwasher (15-25 L per cycle), laundry (50-100 L per load). Always check specific appliance ratings.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Usage Per Day Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>