
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Usage Per Person Per Day Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Usage Per Person Per Day Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Usage Equation:
                </p>
<div class="formula-container">
    \[ Usage = \frac{Total}{Persons \times Days} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="total" class="label-box">Total Water Usage (L):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="total" name="total" step="0.01" min="0" value="<?php echo isset($_POST['total']) ? htmlspecialchars($_POST['total']) : ''; ?>" required>
                                <span class="calc-input">L</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="persons" class="label-box">Number of Persons:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="persons" name="persons" min="1" value="<?php echo isset($_POST['persons']) ? htmlspecialchars($_POST['persons']) : ''; ?>" required>
                                <span class="calc-input">persons</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="days" class="label-box">Number of Days:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="days" name="days" min="1" value="<?php echo isset($_POST['days']) ? htmlspecialchars($_POST['days']) : ''; ?>" required>
                                <span class="calc-input">days</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['total']) && 
                        isset($_POST['persons']) &&
                        isset($_POST['days'])) {
                        
                        // Get input values
                        $total = floatval($_POST['total']);
                        $persons = intval($_POST['persons']);
                        $days = intval($_POST['days']);

                        if ($total > 0 && $persons > 0 && $days > 0) {
                            // Calculate water usage per person per day
                            $usage = $total / ($persons * $days);
                            $usage = round($usage, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Usage Per Person Per Day:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($usage) ? htmlspecialchars($usage) . " L/person/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Water Usage Per Person Per Day?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Usage Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Water Usage Per Person Per Day?</h3>
                <p>
Water Usage Per Person Per Day is a measurement that calculates the average amount of water consumed by each individual in a household or group over a 24-hour period. This metric helps in understanding water consumption patterns and promoting water conservation.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water usage equation:
                </p>
                <div class="formula-2-container">
                    \[ Usage = \frac{Total}{Persons \times Days} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Total \) — Total water usage in liters</li>
                        <li>\( Persons \) — Number of people in the household/group</li>
                        <li>\( Days \) — Number of days measured</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation divides the total water consumption by the product of the number of persons and days to determine the average daily water usage per person.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Usage Calculation</h3>
                <p>
                    <strong>Details:</strong> Calculating water usage per person per day is essential for monitoring water consumption, identifying potential waste, implementing water conservation measures, and managing water resources efficiently.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter total water usage in liters, number of persons, and number of days. All values must be valid positive numbers (total > 0, persons ≥ 1, days ≥ 1).
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is considered normal water usage per person per day?</strong><br>
                    A: Normal usage varies by region and lifestyle, but typically ranges between 80-150 liters per person per day in developed countries.
                </p>
                <p>
                    <strong>Q2: How can I reduce my water usage?</strong><br>
                    A: Fix leaks, install water-efficient fixtures, take shorter showers, and be mindful of water usage during daily activities.
                </p>
                <p>
                    <strong>Q3: Does this calculation include outdoor water usage?</strong><br>
                    A: Yes, if the total water measurement includes both indoor and outdoor usage. For accurate per-person calculations, ensure all water consumption is included.
                </p>
                <p>
                    <strong>Q4: How often should I calculate water usage?</strong><br>
                    A: Regular monitoring (monthly or quarterly) helps track consumption patterns and the effectiveness of conservation efforts.
                </p>
                <p>
                    <strong>Q5: What factors affect water usage per person?</strong><br>
                    A: Climate, household appliances, personal habits, garden irrigation, and the efficiency of water-using devices all impact individual water consumption.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Usage Per Person Per Day Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>