
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Use Calculations</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Water Use Calculations</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Water Use Formula:
                </p>
<div class="formula-container">
    \[ \text{use (L)} = \text{flow (L/min)} \times \text{time (min)} \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="flow" class="label-box">Flow Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="flow" name="flow" step="0.0001" min="0" value="<?php echo isset($_POST['flow']) ? htmlspecialchars($_POST['flow']) : ''; ?>" required>
                                <span class="calc-input">L/min</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="time" class="label-box">Time:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="time" name="time" min="0" value="<?php echo isset($_POST['time']) ? htmlspecialchars($_POST['time']) : ''; ?>" required>
                                <span class="calc-input">min</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['flow']) && 
                        isset($_POST['time'])) {
                        
                        // Get input values
                        $flow = floatval($_POST['flow']);
                        $time = floatval($_POST['time']);

                        if ($flow > 0 && $time > 0) {
                            // Calculate water use
                            $use = $flow * $time;
                            $use = round($use, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Water Use:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($use) ? htmlspecialchars($use) . " L" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is Water Use Calculation?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Use Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is Water Use Calculation?</h3>
                <p>
Water use calculation determines the total volume of water consumed based on flow rate and time. It's essential for water management, conservation planning, and utility billing.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the water use formula:
                </p>
                <div class="formula-2-container">
                    \[ \text{use (L)} = \text{flow (L/min)} \times \text{time (min)} \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( \text{use} \) — Total water usage in liters</li>
                        <li>\( \text{flow} \) — Flow rate in liters per minute</li>
                        <li>\( \text{time} \) — Time duration in minutes</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> This simple multiplication calculates the total volume of water that passes through a system over a specific time period.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Use Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water use calculation helps in resource management, conservation efforts, cost estimation, and environmental impact assessment.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter flow rate in L/min and time in minutes. Both values must be positive numbers for accurate calculation.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What units should I use for flow rate?</strong><br>
                    A: The calculator uses liters per minute (L/min). Convert from other units if necessary.
                </p>
                <p>
                    <strong>Q2: Can I use this for different time units?</strong><br>
                    A: The calculator uses minutes. Convert hours to minutes (×60) or seconds to minutes (÷60) before input.
                </p>
                <p>
                    <strong>Q3: What is a typical flow rate for household faucets?</strong><br>
                    A: Standard faucets typically have flow rates between 4-8 L/min, depending on water pressure and fixture type.
                </p>
                <p>
                    <strong>Q4: How accurate is this calculation?</strong><br>
                    A: The calculation is mathematically precise. Accuracy depends on the precision of your flow rate and time measurements.
                </p>
                <p>
                    <strong>Q5: Can this be used for industrial applications?</strong><br>
                    A: Yes, the formula applies to any water flow calculation regardless of scale, from household to industrial use.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Water Use Calculations© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>