
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Welsh Water Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Welsh Water Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Welsh Water Usage Formula:
                </p>
<div class="formula-container">
    \[ Usage = \sum(DailyUses \times WelshRates) \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="daily_uses" class="label-box">Daily Uses:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="daily_uses" name="daily_uses" step="0.01" min="0" value="<?php echo isset($_POST['daily_uses']) ? htmlspecialchars($_POST['daily_uses']) : ''; ?>" required>
                                <span class="calc-input">uses/day</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="welsh_rates" class="label-box">Welsh Rates:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="welsh_rates" name="welsh_rates" step="0.01" min="0" value="<?php echo isset($_POST['welsh_rates']) ? htmlspecialchars($_POST['welsh_rates']) : ''; ?>" required>
                                <span class="calc-input">L/use</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['daily_uses']) && 
                        isset($_POST['welsh_rates'])) {
                        
                        // Get input values
                        $daily_uses = floatval($_POST['daily_uses']);
                        $welsh_rates = floatval($_POST['welsh_rates']);

                        if ($daily_uses > 0 && $welsh_rates > 0) {
                            // Calculate usage
                            $usage = $daily_uses * $welsh_rates;
                            $usage = round($usage, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Usage:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($usage) ? htmlspecialchars($usage) . " L/day" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What Is The Welsh Water Calculator?</a></li>
                    <li><a href="#section2">2. How Does The Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance Of Water Usage Calculation</a></li>
                    <li><a href="#section4">4. Using The Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What Is The Welsh Water Calculator?</h3>
                <p>
The Welsh Water Calculator estimates daily water usage based on the number of uses and Welsh water rates. It provides an accurate assessment of water consumption for households and businesses in Wales.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does The Calculator Work?</h3>
                <p>
                    The calculator uses the Welsh Water formula:
                </p>
                <div class="formula-2-container">
                    \[ Usage = \sum(DailyUses \times WelshRates) \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( DailyUses \) — Number of water uses per day</li>
                        <li>\( WelshRates \) — Water consumption rate in liters per use</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation multiplies the number of daily water uses by the standard Welsh water consumption rate to calculate total daily usage.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance Of Water Usage Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water usage estimation is crucial for water conservation efforts, billing accuracy, and sustainable resource management in Wales.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using The Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the number of daily water uses and the Welsh water rate in liters per use. All values must be valid positive numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What constitutes a "water use"?</strong><br>
                    A: A water use refers to any discrete water-consuming activity such as flushing a toilet, running a tap, or using a shower.
                </p>
                <p>
                    <strong>Q2: Where can I find Welsh water rates?</strong><br>
                    A: Welsh water rates are typically provided by water utility companies or can be found in water conservation guidelines for Wales.
                </p>
                <p>
                    <strong>Q3: How accurate is this calculation?</strong><br>
                    A: The calculation provides an estimate based on standard rates. Actual usage may vary based on specific appliances and usage patterns.
                </p>
                <p>
                    <strong>Q4: Can this calculator be used for commercial properties?</strong><br>
                    A: Yes, the calculator can be used for both residential and commercial properties, though commercial rates may differ.
                </p>
                <p>
                    <strong>Q5: How often should I calculate my water usage?</strong><br>
                    A: Regular calculation (monthly or quarterly) helps track consumption patterns and identify opportunities for water conservation.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Welsh Water Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
