
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Welsh Water Cost Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Welsh Water Cost Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Welsh Water Cost Formula:
                </p>
<div class="formula-container">
    \[ cost = usage \times welsh\_rate + fixed \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="usage" class="label-box">Usage:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="usage" name="usage" step="0.01" min="0" value="<?php echo isset($_POST['usage']) ? htmlspecialchars($_POST['usage']) : ''; ?>" required>
                                <span class="calc-input">m³</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="welsh_rate" class="label-box">Welsh Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="welsh_rate" name="welsh_rate" step="0.0001" min="0" value="<?php echo isset($_POST['welsh_rate']) ? htmlspecialchars($_POST['welsh_rate']) : ''; ?>" required>
                                <span class="calc-input">currency/m³</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="fixed" class="label-box">Fixed Cost:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="fixed" name="fixed" step="0.01" min="0" value="<?php echo isset($_POST['fixed']) ? htmlspecialchars($_POST['fixed']) : ''; ?>" required>
                                <span class="calc-input">currency</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['usage']) && 
                        isset($_POST['welsh_rate']) &&
                        isset($_POST['fixed'])) {
                        
                        // Get input values
                        $usage = floatval($_POST['usage']);
                        $welsh_rate = floatval($_POST['welsh_rate']);
                        $fixed = floatval($_POST['fixed']);

                        if ($usage >= 0 && $welsh_rate >= 0 && $fixed >= 0) {
                            // Calculate cost using Welsh water formula
                            $cost = $usage * $welsh_rate + $fixed;
                            $cost = round($cost, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Cost:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($cost) ? htmlspecialchars($cost) . " currency" : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Welsh Water Cost Calculator?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Cost Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Welsh Water Cost Calculator?</h3>
                <p>
The Welsh Water Cost Calculator estimates the total water cost based on usage volume, Welsh water rate, and fixed charges. It provides an accurate assessment of water expenses for households and businesses in Wales.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the Welsh water cost formula:
                </p>
                <div class="formula-2-container">
                    \[ cost = usage \times welsh\_rate + fixed \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( usage \) — Water consumption in cubic meters (m³)</li>
                        <li>\( welsh\_rate \) — Welsh water rate in currency per m³</li>
                        <li>\( fixed \) — Fixed charges in currency</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The equation calculates total water cost by multiplying usage volume by the Welsh water rate and adding any fixed charges.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Cost Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water cost estimation is crucial for budgeting household expenses, managing business operational costs, and understanding water consumption patterns.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter water usage in m³, Welsh water rate in currency/m³, and fixed charges in currency. All values must be non-negative numbers.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: What is included in the fixed charges?</strong><br>
                    A: Fixed charges typically include service fees, meter maintenance costs, and other standard charges that don't vary with water consumption.
                </p>
                <p>
                    <strong>Q2: How often do Welsh water rates change?</strong><br>
                    A: Water rates are typically reviewed annually and may change based on regulatory decisions and infrastructure investment needs.
                </p>
                <p>
                    <strong>Q3: Are there different rates for different customer types?</strong><br>
                    A: Yes, residential, commercial, and industrial customers may have different rate structures and fixed charges.
                </p>
                <p>
                    <strong>Q4: How can I reduce my water costs?</strong><br>
                    A: Reducing water consumption through efficient appliances, fixing leaks, and changing usage habits can significantly lower water costs.
                </p>
                <p>
                    <strong>Q5: Where can I find current Welsh water rates?</strong><br>
                    A: Current rates are available on the Welsh Water official website or through your water bill statement.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Welsh Water Cost Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
