
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wessex Water Meter Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Wessex Water Meter Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Usage Calculation Formula:
                </p>
<div class="formula-container">
    \[ Usage = Current\ Reading - Previous\ Reading \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="current_reading" class="label-box">Current Reading:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="current_reading" name="current_reading" step="0.0001" min="0" value="<?php echo isset($_POST['current_reading']) ? htmlspecialchars($_POST['current_reading']) : ''; ?>" required>
                                <span class="calc-input">m³</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="previous_reading" class="label-box">Previous Reading:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="previous_reading" name="previous_reading" step="0.0001" min="0" value="<?php echo isset($_POST['previous_reading']) ? htmlspecialchars($_POST['previous_reading']) : ''; ?>" required>
                                <span class="calc-input">m³</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['current_reading']) && 
                        isset($_POST['previous_reading'])) {
                        
                        // Get input values
                        $current_reading = floatval($_POST['current_reading']);
                        $previous_reading = floatval($_POST['previous_reading']);

                        if ($current_reading >= 0 && $previous_reading >= 0 && $current_reading >= $previous_reading) {
                            // Calculate usage
                            $usage = $current_reading - $previous_reading;
                            $usage = round($usage, 4);
                        } else {
                            $error = "Invalid readings: Current reading must be greater than or equal to previous reading.";
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Usage:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($usage) ? htmlspecialchars($usage) . " m³" : (isset($error) ? $error : ""); ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Wessex Water Meter Calculator?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Water Usage Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Wessex Water Meter Calculator?</h3>
                <p>
The Wessex Water Meter Calculator is a tool designed to calculate water usage by finding the difference between current and previous meter readings. It helps customers track their water consumption accurately.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses a simple formula:
                </p>
                <div class="formula-2-container">
                    \[ Usage = Current\ Reading - Previous\ Reading \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Current\ Reading \) — The current water meter reading in cubic meters (m³)</li>
                        <li>\( Previous\ Reading \) — The previous water meter reading in cubic meters (m³)</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The calculation subtracts the previous reading from the current reading to determine the amount of water used during the billing period.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Water Usage Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate water usage calculation is essential for proper billing, conservation efforts, and detecting potential leaks in the water system.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter both current and previous readings in cubic meters (m³). Ensure the current reading is greater than or equal to the previous reading for accurate results.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: Where can I find my water meter readings?</strong><br>
                    A: Your water meter is typically located outside your property, often near the property boundary or in a meter box.
                </p>
                <p>
                    <strong>Q2: How often should I read my water meter?</strong><br>
                    A: It's recommended to read your meter monthly to track usage patterns and detect potential leaks early.
                </p>
                <p>
                    <strong>Q3: What should I do if my usage seems unusually high?</strong><br>
                    A: Check for leaks in your plumbing system or consider if there have been any changes in your water usage habits.
                </p>
                <p>
                    <strong>Q4: Can I use this calculator for any water meter?</strong><br>
                    A: Yes, this calculator works for any water meter that measures in cubic meters, though it's specifically designed for Wessex Water customers.
                </p>
                <p>
                    <strong>Q5: How is my bill calculated from water usage?</strong><br>
                    A: Water companies typically charge based on the cubic meters used, plus any fixed charges or standing rates.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Wessex Water Meter Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
