
<?php
ini_set('display_errors', 'Off');
ini_set('log_errors', 'off');
?>
<?php  
    $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 4); 
    if (preg_match("/zh-c/i", $lang)) 
    header("Location:/404.html");
?> <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Yorkshire Water Meter Reading Calculator</title>
<link rel="stylesheet" href="/css/new.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .calc-input {
            margin-left: 10px;
            padding: 5px;
        }
        .input-with-unit {
            display: flex;
            align-items: center;
        }
		.formula-container {
    text-align: center;
    margin: 10px 0;
    max-width: 350px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
		.formula-2-container {
    text-align: center;
    margin: 10px 0;
    max-width: 550px; 
    overflow-x: auto; 
    white-space: nowrap; 
    padding: 5px; 
    border: 1px solid #ccc;
}
        nav {
            text-align: left;
            margin: 20px 0;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
        }
        nav li {
            display: block;
            margin: 10px 0;
        }
        nav a {
            text-decoration: none;
            color: #007bff;
        }
        nav a:hover {
            text-decoration: underline;
        }
    </style>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-4727544981520752"
     crossorigin="anonymous"></script>
</head>
<body class="show">
    <div class="top">
        <a href="/"><img src="/img/5.png"/>Home</a>
        <a href="javascript:goBack();"><img src="/img/6.png"/>Back</a>
    </div>
    <div class="calcve">
        <div class="calc">
            <div id="meta"></div>
            <div id="title">
                <h2>Yorkshire Water Meter Reading Calculator</h2>
            </div>
            <div class="container">
                <div class="image-container">
                   <p>
                    Bill Calculation Formula:
                </p>
<div class="formula-container">
    \[ Bill (\text{\pounds}) = (\text{Current reading} - \text{Previous reading}) \times \text{Rate} (\text{\pounds/unit}) + \text{Fixed charge} (\text{\pounds}) \]
</div>
<p><script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
<!-- auto -->
<ins class="adsbygoogle"
 style="display:block;max-width:400px;height:100%;"
     data-ad-client="ca-pub-4727544981520752"
     data-ad-slot="9471236469"
     data-ad-format="auto"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script></p>
                </div>
                <div class="form-container">
                    <form method="post" action="<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>" onsubmit="setFormAction(this)">
                        <div class="form-group">
                            <label for="current_reading" class="label-box">Current Reading (units):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="current_reading" name="current_reading" step="0.0001" min="0" value="<?php echo isset($_POST['current_reading']) ? htmlspecialchars($_POST['current_reading']) : ''; ?>" required>
                                <span class="calc-input">units</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="previous_reading" class="label-box">Previous Reading (units):</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="previous_reading" name="previous_reading" step="0.0001" min="0" value="<?php echo isset($_POST['previous_reading']) ? htmlspecialchars($_POST['previous_reading']) : ''; ?>" required>
                                <span class="calc-input">units</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="rate" class="label-box">Rate:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="rate" name="rate" step="0.0001" min="0" value="<?php echo isset($_POST['rate']) ? htmlspecialchars($_POST['rate']) : ''; ?>" required>
                                <span class="calc-input">£/unit</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="fixed_charge" class="label-box">Fixed Charge:</label>
                            <div class="input-with-unit">
                                <input class="calc-input" type="number" id="fixed_charge" name="fixed_charge" step="0.0001" min="0" value="<?php echo isset($_POST['fixed_charge']) ? htmlspecialchars($_POST['fixed_charge']) : ''; ?>" required>
                                <span class="calc-input">£</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <input class="calc-input" type="submit" value="Calculate">
                        </div>
                    </form>

                    <?php
                    if ($_SERVER["REQUEST_METHOD"] == "POST" && 
                        isset($_POST['current_reading']) && 
                        isset($_POST['previous_reading']) &&
                        isset($_POST['rate']) &&
                        isset($_POST['fixed_charge'])) {
                        
                        // Get input values
                        $current_reading = floatval($_POST['current_reading']);
                        $previous_reading = floatval($_POST['previous_reading']);
                        $rate = floatval($_POST['rate']);
                        $fixed_charge = floatval($_POST['fixed_charge']);

                        if ($current_reading >= $previous_reading && $rate >= 0 && $fixed_charge >= 0) {
                            // Calculate bill
                            $units_used = $current_reading - $previous_reading;
                            $bill = ($units_used * $rate) + $fixed_charge;
                            $bill = round($bill, 2);
                        }
                    }
                    ?>

                    <div class="result-box">
                        <label>Bill Amount:</label>
                        <input class="calc-input" type="text" value='<?php echo isset($bill) ? "£" . htmlspecialchars($bill) : ""; ?>' readonly>
                    </div>
                </div>
            </div>
                        <div class="jiedu">
             <?php
               include "unit.php";
               ?>
			 <nav>
                <ul>
                    <li><a href="#section1">1. What is the Yorkshire Water Meter Reading Calculator?</a></li>
                    <li><a href="#section2">2. How Does the Calculator Work?</a></li>
                    <li><a href="#section3">3. Importance of Accurate Bill Calculation</a></li>
                    <li><a href="#section4">4. Using the Calculator</a></li>
                    <li><a href="#section5">5. Frequently Asked Questions (FAQ)</a></li>
                </ul>
            </nav>
                <h3 id="section1" style="text-align: center;">1. What is the Yorkshire Water Meter Reading Calculator?</h3>
                <p>
The Yorkshire Water Meter Reading Calculator is a tool designed to help customers estimate their water bill based on meter readings. It calculates the bill amount using the current and previous meter readings, the rate per unit, and any fixed charges.
</p>

                <h3 id="section2" style="text-align: center;">2. How Does the Calculator Work?</h3>
                <p>
                    The calculator uses the following formula:
                </p>
                <div class="formula-2-container">
                    \[ Bill (\text{\pounds}) = (\text{Current reading} - \text{Previous reading}) \times \text{Rate} (\text{\pounds/unit}) + \text{Fixed charge} (\text{\pounds}) \]
                </div>
                <p>
                    Where:
                    <ul>
                        <li>\( Current\ reading \) — Current meter reading in units</li>
                        <li>\( Previous\ reading \) — Previous meter reading in units</li>
                        <li>\( Rate \) — Rate per unit in British pounds</li>
                        <li>\( Fixed\ charge \) — Fixed charge in British pounds</li>
                    </ul>
                </p>
                <p>
                    <strong>Explanation:</strong> The calculator first determines the units used by subtracting the previous reading from the current reading. It then multiplies this by the rate per unit and adds any fixed charges to arrive at the total bill amount.
                </p>

                <h3 id="section3" style="text-align: center;">3. Importance of Accurate Bill Calculation</h3>
                <p>
                    <strong>Details:</strong> Accurate bill calculation helps customers understand their water consumption patterns, budget effectively, and identify any discrepancies in their bills. It promotes transparency and trust between the water provider and customers.
                </p>

                <h3 id="section4" style="text-align: center;">4. Using the Calculator</h3>
                <p>
                    <strong>Tips:</strong> Enter the current and previous meter readings in units, the rate per unit in British pounds, and the fixed charge in British pounds. Ensure that the current reading is greater than or equal to the previous reading and that all values are non-negative.
                </p>

                <h3 id="section5" style="text-align: center;">5. Frequently Asked Questions (FAQ)</h3>
                <p>
                    <strong>Q1: How often should I take meter readings?</strong><br>
                    A: It is recommended to take meter readings monthly to monitor usage and ensure accurate billing.
                </p>
                <p>
                    <strong>Q2: What should I do if my current reading is less than the previous reading?</strong><br>
                    A: This may indicate an error in reading or recording. Please double-check your readings or contact Yorkshire Water for assistance.
                </p>
                <p>
                    <strong>Q3: Are there different rates for different consumption levels?</strong><br>
                    A: Yorkshire Water may have tiered rates. Check your tariff details or contact customer service for specific rate information.
                </p>
                <p>
                    <strong>Q4: What is included in the fixed charge?</strong><br>
                    A: The fixed charge typically covers the cost of maintaining the water supply infrastructure and is a constant amount regardless of usage.
                </p>
                <p>
                    <strong>Q5: Can I use this calculator for estimated bills?</strong><br>
                    A: Yes, this calculator can provide an estimate based on your inputs. For precise billing, refer to your actual bill from Yorkshire Water.
                </p>
            </div>
           
            <div class="jiedu" style="text-align: center;">
                Yorkshire Water Meter Reading Calculator© - All Rights Reserved 2025
            </div>
        </div>
    </div>
     <script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'water';
            const sub = '.vovkey';
            const tld = '.com';
            const path = '/<?php

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "calc.php?utm_source=", $current_url);


echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }

        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>